/**
 * Project Name:activity-center-api File Name:LittleGameResourceDto.java Package
 * Name:cn.com.duiba.activity.center.api.dto.gamecenter Date:2016年10月17日下午3:28:34 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.api.dto.gamecenter;

import cn.com.duiba.activity.center.api.dto.BaseActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName:LittleGameResourceDto <br/>
 * Date: 2016年10月17日 下午3:28:34 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public class LittleGameResourceDto extends BaseActivityDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -2219934783558933298L;

    /** 屏蔽ID. */
    private Long              shieldId;

    /** 小游戏id. */
    private Long              activityId;

    /** 活动类型：固定为小游戏. */
    private Integer           activityType     = OperatingActivityDto.TypeDuibaLittleGame;

    /** The title. */
    private String            title;

    /** Banner图. */
    private String            bannerImg;

    /** icon图片. */
    private String            iconImg;

    /** 缩略图 */
    private String            smallImg;

    /** 介绍图 */
    private String            recomImg;

    /** 小游戏展示位置. */
    private List<String>      locations;

    /** The gmt create. */
    private Date              gmtCreate;

    /** The gmt modified. */
    private Date              gmtModified;

    /**
     * shieldId.
     *
     * @return the shieldId
     */
    public Long getShieldId() {
        return shieldId;
    }

    /**
     * shieldId.
     *
     * @param shieldId the shieldId to set
     */
    public void setShieldId(Long shieldId) {
        this.shieldId = shieldId;
    }

    /**
     * activityId.
     *
     * @return the activityId
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * activityType.
     *
     * @return the activityType
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * title.
     *
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * bannerImg.
     *
     * @return the bannerImg
     */
    public String getBannerImg() {
        return bannerImg;
    }

    /**
     * bannerImg.
     *
     * @param bannerImg the bannerImg to set
     */
    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    /**
     * iconImg.
     *
     * @return the iconImg
     */
    public String getIconImg() {
        return iconImg;
    }

    /**
     * iconImg.
     *
     * @param iconImg the iconImg to set
     */
    public void setIconImg(String iconImg) {
        this.iconImg = iconImg;
    }

    /**
     * locations.
     *
     * @return the locations
     */
    public List<String> getLocations() {
        return locations;
    }

    /**
     * locations.
     *
     * @param locations the locations to set
     */
    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * smallImg.
     *
     * @return the smallImg
     */
    public String getSmallImg() {
        return smallImg;
    }

    /**
     * smallImg.
     *
     * @param smallImg the smallImg to set
     */
    public void setSmallImg(String smallImg) {
        this.smallImg = smallImg;
    }

    /**
     * recomImg.
     *
     * @return the recomImg
     */
    public String getRecomImg() {
        return recomImg;
    }

    /**
     * recomImg.
     *
     * @param recomImg the recomImg to set
     */
    public void setRecomImg(String recomImg) {
        this.recomImg = recomImg;
    }

    /**
     * 简单描述该方法的实现功能（可选）.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LittleGameResourceDto [shieldId=");
        builder.append(shieldId);
        builder.append(", activityId=");
        builder.append(activityId);
        builder.append(", activityType=");
        builder.append(activityType);
        builder.append(", title=");
        builder.append(title);
        builder.append(", bannerImg=");
        builder.append(bannerImg);
        builder.append(", iconImg=");
        builder.append(iconImg);
        builder.append(", smallImg=");
        builder.append(smallImg);
        builder.append(", recomImg=");
        builder.append(recomImg);
        builder.append(", locations=");
        builder.append(locations);
        builder.append(", gmtCreate=");
        builder.append(gmtCreate);
        builder.append(", gmtModified=");
        builder.append(gmtModified);
        builder.append("]");
        return builder.toString();
    }

}
