package cn.com.duiba.activity.center.api.remoteservice.singlelottery;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/24.
 */
@AdvancedFeignClient
public interface RemoteSingleLotteryOrderService {
    //from SingleLotteryOrderSimpleDAO
    
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID查询单品抽奖订单
     * @param id
     * @return
     * @since JDK 1.6
     */
    SingleLotteryOrderDto find(Long id);

    /**
     * 
     * countByConsumerIdAndOptionType:(这里用一句话描述这个方法的作用). <br/>
     * 统计奖项用户中奖次数
     * @param activityId
     * @param consumerId
     * @param optionType
     * @return
     * @since JDK 1.6
     */
    Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据ID集合查询订单
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findAllByIds(List<Long> ids);

    /**
     * 
     * findLotteryCountByComsumer:(这里用一句话描述这个方法的作用). <br/>
     * 查询当前用户在当前活动当前APP的抽奖次数
     * @param activityId
     * @param appId
     * @param consumerId
     * @return
     * @since JDK 1.6
     */
    Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId);

    /**
     * 
     * findCountByComsumerTime:(这里用一句话描述这个方法的作用). <br/>
     * 查询当天当前用户在当前活动当前APP的抽奖次数
     * @param activityId
     * @param appId
     * @param consumerId
     * @param statTime
     * @param endTime
     * @return
     * @since JDK 1.6
     */
    Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime);

    /**
     * 
     * findFrontLotteryList:(这里用一句话描述这个方法的作用). <br/>
     * 查询前台显示5条中奖名单
     * @param activityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findFrontLotteryList(Long activityId, Long appId);

    /**
     * 
     * findByAppAndDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * 根据上游订单号查单
     * @param appId
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    SingleLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId);

    /**
     * 
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据订单ID查询订单信息
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findByIds(List<Long> ids);
    
    /**
     * 
     * findByInOrderIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据主订单ID集合查询单品订单
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findByInOrderIds(List<Long> ids);

    /**
     * 
     * findAllByLtGmtCreateAndExchangeStatus:(这里用一句话描述这个方法的作用). <br/>
     * 查询创建时间小于 PARAM的订单
     * 扫描24小时没有领奖的订单，查询较慢，待优化
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findAllByLtGmtCreateAndExchangeStatus();

    /**
     * 
     * findFailCountByOperatingActivityIds:(这里用一句话描述这个方法的作用). <br/>
     * 获取失败订单数
     * @param operatingActivityIds
     * @return
     * @since JDK 1.6
     */
    List<DeveloperActivityStatisticsDto> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds);

    /**
     * 
     * findByLimit:(这里用一句话描述这个方法的作用). <br/>
     * 单品抽奖订单分页
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> findByLimit(Map<String, Object> paramMap);

    /**
     * 
     * findByCount:(这里用一句话描述这个方法的作用). <br/>
     * 单品抽奖订单分页条数
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    Long findByCount(Map<String, Object> paramMap);

    /**
     * 
     * countWintimesByOptionType:(这里用一句话描述这个方法的作用). <br/>
     * 根据奖项类型查询中奖人数
     * @param operatingActivityIds
     * @param statTime
     * @param endTime
     * @param optionType
     * @return
     * @since JDK 1.6
     */
    Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType);

    /**
     * 
     * getWinningListByOperatingActivityIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据开发者单品活动ID列表得到活动ID对中大奖人数的Map
     * @param operatingActivityIds
     * @return
     * @since JDK 1.6
     */
    List<SingleLotteryOrderDto> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds);

    // from SingleLotteryOrderStatusChangeDAO

    /**
     * 
     * updateExchangeStatusToFail:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单领奖状态为失败
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * updateExchangeStatusToOverdue:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单领奖状态为过期失效
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * updateStatusToSuccess:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单状态成功，领奖状态待领奖
     * @param id
     * @return
     * @since JDK 1.6
     */
    int updateStatusToSuccess(long id);

    /**
     * 
     * updateStatusToFail:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单状态失败
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     * @since JDK 1.6
     */
    int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer);

    /**
     * 
     * updatePrizeTypeToThanks:(这里用一句话描述这个方法的作用). <br/>
     * 订单抽奖失败，修改为未中奖
     * @param id
     * @return
     * @since JDK 1.6
     */
    int updatePrizeTypeToThanks(long id);

    /**
     * 
     * doTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 处理领奖
     * @param id
     * @return
     * @since JDK 1.6
     */
    Integer doTakePrize(Long id);

    /**
     * 
     * rollbackTakePrize:(这里用一句话描述这个方法的作用). <br/>
     * 领奖创建主订单失败回滚领奖
     * @param id
     * @return
     * @since JDK 1.6
     */
    Integer rollbackTakePrize(Long id);

    /**
     * 
     * updateLotteryResult:(这里用一句话描述这个方法的作用). <br/>
     * 修改订单抽奖结果
     *
     * @author liyang
     * @param id
     * @param appItemId
     * @param itemId
     * @param prizeName
     * @param prizeType
     * @param prizeDegree
     * @param prizeFacePrice
     * @param optionType
     * @param couponId
     * @return
     * @since JDK 1.6
     */
    Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId);

    // SingleLotteryOrderTextChangeDAO

    /**
     * 
     * updateDeveloperBizId:(这里用一句话描述这个方法的作用). <br/>
     * 修改开发者订单号
     * @param id
     * @param bizId
     * @return
     * @since JDK 1.6
     */
    int updateDeveloperBizId(long id, String bizId);

    /**
     * 
     * updateMainOrderId:(这里用一句话描述这个方法的作用). <br/>
     * 修改主订单ID
     * @param id
     * @param orderId
     * @return
     * @since JDK 1.6
     */
    int updateMainOrderId(long id, Long orderId);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 新增单品抽奖订单
     * @param singleLotteryOrderDO
     * @return
     * @since JDK 1.6
     */
    SingleLotteryOrderDto insert(SingleLotteryOrderDto singleLotteryOrderDO);
}
