package cn.com.duiba.activity.center.api.dto.pyramid_spread;

import cn.com.duiba.activity.center.api.enums.ActThrowChannelEnum;
import cn.com.duiba.activity.center.api.enums.pyramid_spread.PyramidSpreadNewRewardTypeEnum;
import cn.com.duiba.activity.center.api.enums.pyramid_spread.PyramidSpreadPlayTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 师徒体系活动配置
 * Created by HePeng on 2019/04/19 10:58.
 */
public class PyramidSpreadConfigDto implements Serializable {
    private static final long serialVersionUID = -868622226305499296L;

    /**
    * 主键
    */
    private Long id;

    /**
    * 活动id
    */
    private Long actId;

    /**
    * 应用id
    */
    private Long appId;

    /**
    * 活动投放应用类型
    */
    private ActThrowChannelEnum actThrowChannelEnum;

    /**
    * 玩法类型
    */
    private PyramidSpreadPlayTypeEnum playTypeEnum;

    /**
    * 活动标题
    */
    private String title;

    /**
    * 活动规则
    */
    private String rule;

    /**
    * 入口缩略图链接
    */
    private String smallImage;

    /**
    * banner图链接
    */
    private String bannerImage;

    /**
    * 开始时间
    */
    private Date startTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 新人奖励类型
    */
    private PyramidSpreadNewRewardTypeEnum newRewardTypeEnum;

    /**
    * 新人奖励固定数值（单位：分）
    */
    private Long newRewardFixed;

    /**
     * 新人奖励随机区间区间列表
     */
    private List<NewRewardRegion> newRewardRegionList;

    /**
    * 邀请奖励数值（单位：分）
    */
    private Integer inviteReward;

    /**
    * 最多可邀请人数
    */
    private Integer maxInvite;

    /**
    * 二级抽成比率
    */
    private Integer levelTwoRate;

    /**
    * 三级抽成比率
    */
    private Integer levelThreeRate;

    /**
    * 总预算（单位：分）
    */
    private Integer totalBudget;

    /**
    * 预算告警开关
    */
    private Boolean budgetWarnSwitch;

    /**
    * 告警预算（单位：分）
    */
    private Integer budgetWarnAmount;

    /**
    * 预算告警手机号
    */
    private String budgetWarnTel;

    /**
    * 对应的自定义账户id
    */
    private Long accountId;

    /**
    * 界面配置json串
    */
    private String skinJson;

    /**
    * 分享标题
    */
    private String shareTitle;

    /**
    * 分享副标题
    */
    private String shareSubTitle;

    /**
    * 分享图片链接
    */
    private String sharePic;

    /**
    * 分享应用名称
    */
    private String shareAppName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public ActThrowChannelEnum getActThrowChannelEnum() {
        return actThrowChannelEnum;
    }

    public void setActThrowChannelEnum(ActThrowChannelEnum actThrowChannelEnum) {
        this.actThrowChannelEnum = actThrowChannelEnum;
    }

    public PyramidSpreadPlayTypeEnum getPlayTypeEnum() {
        return playTypeEnum;
    }

    public void setPlayTypeEnum(PyramidSpreadPlayTypeEnum playTypeEnum) {
        this.playTypeEnum = playTypeEnum;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public PyramidSpreadNewRewardTypeEnum getNewRewardTypeEnum() {
        return newRewardTypeEnum;
    }

    public void setNewRewardTypeEnum(PyramidSpreadNewRewardTypeEnum newRewardTypeEnum) {
        this.newRewardTypeEnum = newRewardTypeEnum;
    }

    public Long getNewRewardFixed() {
        return newRewardFixed;
    }

    public void setNewRewardFixed(Long newRewardFixed) {
        this.newRewardFixed = newRewardFixed;
    }

    public List<NewRewardRegion> getNewRewardRegionList() {
        return newRewardRegionList;
    }

    public void setNewRewardRegionList(List<NewRewardRegion> newRewardRegionList) {
        this.newRewardRegionList = newRewardRegionList;
    }

    public Integer getInviteReward() {
        return inviteReward;
    }

    public void setInviteReward(Integer inviteReward) {
        this.inviteReward = inviteReward;
    }

    public Integer getMaxInvite() {
        return maxInvite;
    }

    public void setMaxInvite(Integer maxInvite) {
        this.maxInvite = maxInvite;
    }

    public Integer getLevelTwoRate() {
        return levelTwoRate;
    }

    public void setLevelTwoRate(Integer levelTwoRate) {
        this.levelTwoRate = levelTwoRate;
    }

    public Integer getLevelThreeRate() {
        return levelThreeRate;
    }

    public void setLevelThreeRate(Integer levelThreeRate) {
        this.levelThreeRate = levelThreeRate;
    }

    public Integer getTotalBudget() {
        return totalBudget;
    }

    public void setTotalBudget(Integer totalBudget) {
        this.totalBudget = totalBudget;
    }

    public Boolean getBudgetWarnSwitch() {
        return budgetWarnSwitch;
    }

    public void setBudgetWarnSwitch(Boolean budgetWarnSwitch) {
        this.budgetWarnSwitch = budgetWarnSwitch;
    }

    public Integer getBudgetWarnAmount() {
        return budgetWarnAmount;
    }

    public void setBudgetWarnAmount(Integer budgetWarnAmount) {
        this.budgetWarnAmount = budgetWarnAmount;
    }

    public String getBudgetWarnTel() {
        return budgetWarnTel;
    }

    public void setBudgetWarnTel(String budgetWarnTel) {
        this.budgetWarnTel = budgetWarnTel;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getSkinJson() {
        return skinJson;
    }

    public void setSkinJson(String skinJson) {
        this.skinJson = skinJson;
    }

    public String getShareTitle() {
        return shareTitle;
    }

    public void setShareTitle(String shareTitle) {
        this.shareTitle = shareTitle;
    }

    public String getShareSubTitle() {
        return shareSubTitle;
    }

    public void setShareSubTitle(String shareSubTitle) {
        this.shareSubTitle = shareSubTitle;
    }

    public String getSharePic() {
        return sharePic;
    }

    public void setSharePic(String sharePic) {
        this.sharePic = sharePic;
    }

    public String getShareAppName() {
        return shareAppName;
    }

    public void setShareAppName(String shareAppName) {
        this.shareAppName = shareAppName;
    }
}

