package cn.com.duiba.activity.center.api.remoteservice.happycodenew;

import cn.com.duiba.activity.center.api.dto.happycodenew.HappyCodeUserRecordDto;
import cn.com.duiba.activity.center.api.params.HappyCodeExchangeParam;
import cn.com.duiba.activity.center.api.params.HappyCodeExchangeResultParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;

/**
 * Created by Liugq on 2019/3/29.
 */
@AdvancedFeignClient
public interface RemoteHappyCodeUserRecordService {

    /**
     * 查询用户第一个待领取的记录
     * @param actId
     * @param consumerId
     * @return
     */
    HappyCodeUserRecordDto queryPrizeRecord(Long actId, Long consumerId);

    HappyCodeUserRecordDto findById(Long id);

    Integer updateById(HappyCodeUserRecordDto dto);

    /**
     * 初始化开心码记录
     * @return
     */
    HappyCodeExchangeResultParam initUserRecord(HappyCodeExchangeParam param);

    /**
     * 最新的参与用户
     * @param phaseId
     * @param  limit
     * @return
     */
    List<Long> selectLastestJoinData(Long phaseId, Integer limit);

    /**
     * 查询用户参与记录（排除进行中的）
     * @param consumerId
     * @param pageNo
     * @param pageSize
     */
    Page<HappyCodeUserRecordDto> selectUserHistory(Long actId, Long consumerId, Integer pageNo, Integer pageSize);

    /**
     * 根据期次id批量查询用户的参与记录
     * @param phaseIds
     * @return
     */
    List<HappyCodeUserRecordDto> selectUserRecordByPhaseIds(Long consumerId, List<Long> phaseIds);

    /**
     * 根据期次id查询用户的参与记录
     * @param phaseId
     * @return
     */
    HappyCodeUserRecordDto findByPhaseAndConsumer(Long phaseId, Long consumerId);

    /**
     * 得到扣积分处理结果后的业务处理
     */
    Boolean dealAfterSubCreditsCallBack(String bizId, Boolean success);

    /**
     * 得到加积分处理结果后的业务处理
     */
    Boolean dealAfterReturnCreditsCallBack(String bizId, Boolean success);

}
