package cn.com.duiba.activity.center.api.params;

import cn.com.duiba.wolf.utils.NumberUtils;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hww on 2018/8/6 下午8:32.
 */
public class MultiRankDataInfo implements Serializable, Comparable<MultiRankDataInfo> {

    private static final long serialVersionUID = -1033527279134371900L;

    /** 记录id */
    private Long id;
    /** 排名 */
    private String rank;
    /** 用户id */
    private Long consumerId;
    /** 应用名称 */
    private String appName;
    /** 最高记录 */
    private Long maxScore;
    /** 最高记录时间 */
    private Date maxScoreDate;
    /** 是否有效 */
    private boolean cheat;
    /** 分榜id */
    private Long subId;
    /** appId */
    private Long appId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRank() {
        return rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getMaxScore() {
        return maxScore;
    }

    public void setMaxScore(Long maxScore) {
        this.maxScore = maxScore;
    }

    public Date getMaxScoreDate() {
        return maxScoreDate;
    }

    public void setMaxScoreDate(Date maxScoreDate) {
        this.maxScoreDate = maxScoreDate;
    }

    public boolean isCheat() {
        return cheat;
    }

    public void setCheat(boolean cheat) {
        this.cheat = cheat;
    }

    public Long getSubId() {
        return subId;
    }

    public void setSubId(Long subId) {
        this.subId = subId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }


    @Override
    public int compareTo(@NotNull MultiRankDataInfo o) {
        //排序规则
        //1.名次升序  名次不可能重复  没有名次走分数排序
        //2.分数降序  分数重复       走最高纪录时间排序
        //3.时间升序  时间重复不再做区分  理论上来说没有名次就没有什么实际意义了
        if (NumberUtils.isNumeric(this.rank) || NumberUtils.isNumeric(o.rank)) {
            return doCompareRank(o.rank);
        }
        if (this.maxScore != null || o.maxScore != null) {
            return doCompareMaxScore(o);
        }
        if (this.maxScoreDate != null || o.maxScoreDate != null) {
            return doCompareMaxScoreDate(o.maxScoreDate);
        }
        return 0;
    }

    private int doCompareMaxScoreDate(Date maxScoreDate) {
        if (null == this.maxScoreDate) {
            return 1;
        }
        if (null == maxScoreDate) {
            return -1;
        }
        return this.maxScoreDate.compareTo(maxScoreDate);
    }

    private int doCompareMaxScore(MultiRankDataInfo o) {
        if (this.maxScore == null) {
            return 1;
        }
        if (o.maxScore == null) {
            return -1;
        }
        int duff = (int)(o.maxScore - this.maxScore);
        return duff == 0 ? doCompareMaxScoreDate(o.getMaxScoreDate()) : duff;
    }

    private int doCompareRank(String rank) {
        if (!NumberUtils.isNumeric(this.rank)) {
            return 1;
        }
        if (!NumberUtils.isNumeric(rank)) {
            return -1;
        }
        return Integer.valueOf(this.rank) - Integer.valueOf(rank);
    }
}
