package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.BetResultDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/08
 */
@AdvancedFeignClient
public interface RemoteBackendBetResultService {
    /**
     * 更新状态
     * @param betId betId
     * @param resultStatus resultStatus
     * @return 是否成功
     */
    Integer updateResultStatus(Long betId, Integer resultStatus);

    /**
     * 获取该活动改下的选项结果列表
     * @param betId betId
     * @return List<BetResultDto>
     */
    List<BetResultDto> listByBetId(Long betId);

    /**
     * 批量更新选项结果
     * @param betResultDtoList betResultDtoList
     * @return 更新行数
     */
    Integer batchUpdate(List<BetResultDto> betResultDtoList, Long appId);
}
