package cn.com.duiba.activity.center.api.remoteservice.pyramid_spread;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.pyramid_spread.SpreadConsumerActDto;
import cn.com.duiba.activity.center.api.dto.pyramid_spread.SpreadConsumerBonusDto;
import cn.com.duiba.activity.center.api.dto.pyramid_spread.SpreadConsumerIndexConsumerDataDto;
import cn.com.duiba.activity.center.api.dto.pyramid_spread.SpreadConsumerLevelThreeLeaderDto;
import cn.com.duiba.activity.center.api.dto.pyramid_spread.SpreadConsumerLevelTwoLeaderDto;
import cn.com.duiba.activity.center.api.params.pyramid_spread.SpreadConsumerBonusListQueryParam;
import cn.com.duiba.activity.center.api.params.pyramid_spread.SpreadConsumerLeaderListQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 师徒体系用户数据远程服务
* Created by HePeng on 2019/04/24 13:40.
*/
@AdvancedFeignClient
public interface RemoteSpreadConsumerService {

    /**
     * 获取活动（包含活动状态）
     * @param actId
     * @return
     */
    SpreadConsumerActDto getAct(Long actId);

    /**
     * 首页数据
     * @param actId
     * @param consumerId
     * @return
     */
    SpreadConsumerIndexConsumerDataDto indexConsumerData(Long actId, Long consumerId);

    /**
     * 用户的大财团列表
     * @param queryParam
     * @return
     */
    List<SpreadConsumerLevelTwoLeaderDto> levelTwoLeaderList(SpreadConsumerLeaderListQueryParam queryParam);

    /**
     * 用户的小财团列表
     * @param queryParam
     * @return
     */
    PaginationDto<SpreadConsumerLevelThreeLeaderDto> levelThreeLeaderList(SpreadConsumerLeaderListQueryParam queryParam);

    /**
     * 红包列表
     * @param queryParam
     * @return
     */
    PaginationDto<SpreadConsumerBonusDto> bonusList(SpreadConsumerBonusListQueryParam queryParam);
}
