package cn.com.duiba.activity.center.api.remoteservice.seedredpacket;

import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketDto;
import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketTaskDto;
import cn.com.duiba.activity.center.api.request.SeedRedPacketSaveRequest;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description
 */
@AdvancedFeignClient
public interface RemoteBackendSeedRedPacketService {

    /**
     * 新增
     */
    long insert(SeedRedPacketDto config) throws BizException;

    /**
     * 更新
     */
    boolean updateGeneral(SeedRedPacketDto config);

    /**
     * 删除
     */
    int deleted(Long id);

    /**
     * 物理删除 用于创建活动过程中出错时 删除无用活动数据
     * 谨慎使用
     */
    int deletedPhysical(Long id);

    /**
     * 更新
     */
    boolean updateGeneralExtra(SeedRedPacketDto config, Long consumerId, Long appId);

    /**
     * 删除
     */
    int deletedExtra(Long id, Long consumerId, Long appId);

    /**
     * 状态变更
     */
    int updateStatus(Long id, Integer status);

    /**
     * 分页查询
     */
    Page<SeedRedPacketDto> findByPageApi(PageQuery pageQuery, String title);

    /**
     * 查看详情
     */
    SeedRedPacketDto findById(Long id);

    /**
     * 保存种红包活动 组件化使用
     * 根据{@link SeedRedPacketSaveRequest#forInsert} 字段指定新增或修改
     * 修改的时候如果不需要修改土地解锁任务 可以不传土地解锁任务tasks
     * */
    Long save(SeedRedPacketSaveRequest request);

    /**
     * 根据种红包活动id 查询所有土地的解锁任务信息
     */
    List<SeedRedPacketTaskDto> findTasksByActivityId(Long id);

    /**
     * 更新中红包活动周期
     */
    int updatePeriod(Long id, Long periodId, Date startTime, Date endTime);

    /**
     * 查询所有未结束的活动 并且按照时间进行排序
     * @param appId
     * @return
     */
    List<SeedRedPacketDto> findAllNotEndingActivity(Long appId);

    /**
     * 查询最近一期活动
     */
    SeedRedPacketDto findLatestActivityByAppId(Long appId);

}
