package cn.com.duiba.activity.center.api.remoteservice.shuqi;

import cn.com.duiba.activity.center.api.dto.shuqipk.PkTeamMemberInfoDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2018/12/27 19:47
 * @description:
 */
@AdvancedFeignClient
public interface RemotePkTeamMemberInfoService {

	/**
	 * 加入战队，同时战队信息里面的战队人数加1
	 * @param dto
	 * @return 战队人数
	 */
    Integer insert(PkTeamMemberInfoDto dto) throws BizException;

    /**
	 * 根据用户id，获取用户所属战队
	 */
	PkTeamMemberInfoDto getByConsumerId(Long consumerId);

	/**
	 * 根据战队id查询战队成员
	 */
	List<PkTeamMemberInfoDto> getListByTeamId(Long teamId);

	/**
	 * 根据战队id list批量查询战队成员
	 */
	List<PkTeamMemberInfoDto> getListByTeamIds(List<Long> teamIds);

}
