package cn.com.duiba.activity.center.api.enums.happycodenew;

/**
 * @Author chenxiangge
 * @Date 2019/4/2
 */
public enum ItemPhaseStatusEnum {
    PROCESS(1, "进行中"),
    WAIT_OPEN_PRIZE(2, "待开奖"),
    OPEN_PRIZE(3, "已开奖"),
    PRIZE_ERROR(4, "奖项异常"),
    NOT_REACH(5, "未达标"),
    CANCELLED(6, "取消"),
    ;

    private Integer code;
    private String desc;

    ItemPhaseStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ItemPhaseStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ItemPhaseStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
