package cn.com.duiba.activity.center.api.remoteservice.betv2;

import cn.com.duiba.activity.center.api.dto.activity_order.ActivityOrderDto;
import cn.com.duiba.activity.center.api.dto.bet.BetActGroupDto;
import cn.com.duiba.activity.center.api.dto.betv2.BetV2ConfigResultDto;
import cn.com.duiba.activity.center.api.dto.betv2.BetV2PopUpDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * RemoteBetV2ConfigService
 *
 * @author ChenXiangge
 * @date 27/06/2018
 */
@AdvancedFeignClient
public interface RemoteBetV2ConfigService {

    BetV2ConfigResultDto listByAppId(Long appId, Long consumerId, Integer pageNo, Integer pageSize,Boolean hasUnitIndexPage) throws BizException;

    BetV2PopUpDto getConsumerPopUpInfo(Long appId, Long consumerId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 扣积分成功后的逻辑
     * 1.增加选项次数，还有用户参与情况
     * 2.如果扣的积分为0，可以直接调用这个方法
     *
     * @param activityOrderDto
     */
    void afterCredits(ActivityOrderDto activityOrderDto);

    /**
     * 获取选项的投票次数
     *
     * @return key=optionId value=${betTimes}投票次数
     */
    List<Long> getBetTimes(List<String> redisKeys);

    /**
     * 自动任务开奖
     * 内部启动线程处理
     */
    void doDraw();

    /**
     * 手动开奖
     * 解决消息发送失败pk赛开奖失败问题
     * @param appId
     * @param betId
     */
    void openPrizeManually(Long appId, Long betId);


    /**
     * 判断该活动pk 是否总账户标记逻辑
     * @param  betActGroupDto  活动对象
     * @return 是否接入总账户标记逻辑
     */
    Boolean accessAccountTag(BetActGroupDto betActGroupDto);


    /**
     *@Desc
     *@params
     * accessAccountTag,   是否接入总账户逻辑
     * pkUnitAwardTag, 用户累计
     * cid,  用户id
     * betActGroupDto 活动对象
     *@return  java.lang.Boolean
     *@user  liukai
     *@createDate  2019/2/26
     */
    Boolean beLongTagUserCheck(Boolean accessAccountTag, String pkUnitAwardTag,Long cid, BetActGroupDto betActGroupDto)  throws BizException;

}
