package cn.com.duiba.activity.center.api.remoteservice.creditsfarm;


import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmCropDetailDto;
import cn.com.duiba.activity.center.api.dto.creditsfarm.CropDetailQueryParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * created by liugq in 2019/08/05
 * 种植流水服务
 */
@AdvancedFeignClient
public interface RemoteCreditsFarmCropDetailService {

    Integer updateById(CreditsFarmCropDetailDto dto);

    Long insert(CreditsFarmCropDetailDto dto);

    /**
     * 根据扣积分订单号查询
     * @param orderNum
     * @return
     */
    CreditsFarmCropDetailDto findByOrderNum(String orderNum);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    CreditsFarmCropDetailDto findById(Long id);

    List<CreditsFarmCropDetailDto> selectByCondtion(CropDetailQueryParam param);

    /**
     * 得到扣积分处理结果后的业务处理
     */
    Boolean dealAfterSubCreditsCallBack(String orderNum, Boolean success);

    /**
     * 收获
     * @param id 种植记录主键id
     * @return
     */
    Integer gain(Long id) throws BizException;

    /**
     * 此区域是否有未收取的种植
     * @param consumerId
     * @param actId
     * @param zoneNo
     * @return
     */
    Boolean exsistInZone(Long consumerId, Long actId, Integer zoneNo);

    /**
     * 加速
     * @param consumerId
     * @param actId
     * @param speedTime
     * @throws BizException
     */
    void speed(Long consumerId, Long actId, Long speedTime) throws BizException;

    /**
     * 加速
     * 查询用户当前所有未成熟的种植记录id
     * @param consumerId
     * @param actId
     * @return
     */
    List<Long> selectNotMatureId(Long consumerId, Long actId);
}
