package cn.com.duiba.activity.center.api.remoteservice.creditsfarm;


import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmUserSeedRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * created by liugq in 2019/08/05
 * 用户种子纬度参与数据
 */
@AdvancedFeignClient
public interface RemoteCreditsFarmUserSeedRecordService {

    /**
     * 查新用户此活动下所有种子的种植统计数据
     * @param consumerId
     * @param actId
     * @return
     */
    List<CreditsFarmUserSeedRecordDto> selectByConsumerAndAct(Long consumerId, Long actId);

    /**
     * 根据唯一建查询，查询不到则插入
     * @param dto
     * @return
     */
    CreditsFarmUserSeedRecordDto findOrInsert(CreditsFarmUserSeedRecordDto dto);

    /**
     * 唯一建查询
     * @param consumerId
     * @param actId
     * @param seedId
     * @return
     */
    CreditsFarmUserSeedRecordDto findByUnikey(Long consumerId, Long actId, Long seedId);
}
