package cn.com.duiba.activity.center.api.tool;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br/>
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 * 
 * @author houwen
 */
public enum RedisKeySpace {
	/** 活动每日参与次数 */
	K001("活动每日参与次数"),
	/** 活动每日免费次数 */
	K002("活动每日免费次数"),
	/**签到体系活动签到锁key**/
	K003("签到体系活动签到锁key"),
	/**活动工具皮肤默认数据key**/
	K004("活动工具皮肤默认数据"),
	/**入库活动缓存key**/
	K005("入库活动缓存key"),
	/**更新签到统计数据锁**/
	K006("更新签到统计数据锁key"),
	/**插件活动dto缓存key**/
	K007("插件活动dto缓存key"),
	/**客服配置缓存key**/
	K008("客服配置缓存key"),
	/**活动奖品发放数量**/
	K009("活动奖品发放数量"),
	/**集卡发奖用户锁,用户奖项扣库存时对用户枷锁避免任何的数据变更引起的奖项超发**/
	K010("集卡发奖用户锁"),
	/**多游戏排名基本配置**/
	K011("多游戏排名基本配置"),
	/**多游戏排名一个配置下面的活动列表**/
	K012("多游戏排名一个配置下面的活动列表"),
	/**多游戏排名中一个活动对应的配置项id**/
	K013("多游戏排名中一个活动对应的配置项id"),
	/**多游戏排名中一个配置项用户的总分**/
	K014("多游戏排名中一个配置项用户的总分"),
	/** 直冲奖品防刷每日类型key */
	K015("多游戏排名中一个配置项用户的总分"),
	/**奖项排名中一个配置项用户的总分**/
	K016("奖项排名中一个配置项用户的总分"),
	/**集卡发放-需要获取的后几张卡片数量**/
	K017("需要获取的后几张卡片数量"),
	/**集卡发放-发放概率**/
	K018("发放概率"),
	/**集卡发放-每张卡片单个用户发放上限**/
	K019("每张卡片单个用户发放上限"),
	/** 记录首页弹层曝光过的appId */
	K020("时间段内首页弹层活动曝光记录"),
    K021("热血街舞打call-单个用户不同明星分数"),
	K022("热血街舞打call-单个明星总分"),
	K023("开心码赛事配置信息id"),
	K024("开心码奖项配置信息id"),
	K025("开心码奖项配置信息上的期次id"),
	K026("开心码期次配置信息id"),
	K027("集卡配置信息id"),
	K028("活动工具奖项批量查询"),
	K029("种红包app与种红包活动映射关系"),
	K030("ActivityPrizeOptionService.queryActivityOptionsByConfigId"),
	K031("ActivityPrizeOptionService.find"),
	K032("RemoteRecommendService.findRecommendSkin"),
	K033("OperatingActivityService.findByAppIdAndDuibaHdtoolIdAndDeleted"),
	K034("搜狐咨询收集唇印领奖记录按手机号查询"),
	K035("搜狐咨询收集唇印领奖记录按用户id查询"),
	K036("种红包按活动id查询缓存"),
	K037("种红包成熟时间配置缓存"),
	K038("种红包查询可提现用户列表缓存"),
	K039("种红包查询可提现用户数量缓存"),
	K040("PopupActivityBrick缓存key"),
	K041("皮肤md5值"),
	K042("活动每周参与次数"),
	K043("活动每月参与次数"),
	K044("签到配置,id"),
	K045("签到配置,appId"),
    K046("游戏子订单拓展信息缓存"),
	K047("开心码奖项列表配置信息上的期次id"),
	K048("开心码中奖轮播列表"),

	K050("签到皮肤模板数据缓存"),
	K051("用户游戏记录"),
	K052("用户游戏记录ID映射缓存"),

	K054("种红包用户当日是否第一次收割红包"),
	K055("猜红包用户最近开的红包"),
	K056("猜红包用户红包信息"),
	K057("种红包用户当天已种红包数量"),
	K058("种红包用户当天种的红包可领金额"),
	K059("种红包可提现标记用户登录标记"),

	K053("BetGroupRelationServiceImpl.getListByAppAndStatusAndEndTime"),

	K060("BetGroupRelationServiceImpl.listByBetIdAndGroupIds"),
    K061("AppGroupRelationServiceImpl.listByAppId"),
	K062("BetConfigServiceImpl.findById"),
	K063("BetGroupRelationServiceImpl.listByGroupIdWithCache"),
    K064("BetGroupRelationServiceImpl.countByGroupIdWithCache"),
    K065("BetConfigServiceImpl.listByIdsWitchCache"),
    K066("BetOptionServiceImpl.listByBetIds"),
    K067("BetResultServiceImpl.listByBetIdsWithCache"),
	K068("BetConfigServiceImpl.getListByStatusAndEndTime"),
	K069("BetGroupRelationServiceImpl.listByGroupIdsWithCache"),
	K154("BetGroupRelationServiceImpl.listByValidGroupIdWithCache"),

	K070("博彩活动选项缓存"),
    K071("博彩活动选项积分缓存"),
	K072("博彩活动某一活动的用户参与记录"),
    K073("博彩活动获取某一个活动组活动列表"),
	K074("博彩活动今日活动首页缓存"),
    K075("博彩活动往日竞猜首页缓存"),
    K076("博彩活动首页竞猜单个活动缓存"),
	K077("博彩活动最近4天的活动id列表"),
	K078("pk活动选项押注次数"),
	K079("pk用户弹窗"),
	K080("betConfigService.listByBetIdsOrderByEndTimeAndIdWithCache"),
	KO81("漫漫漫画偶像成长计划用户今日投票次数"),
	KO82("漫漫漫画偶像成长计划角色今日得票数"),
	KO83("漫漫漫画偶像成长计划角色总得票数"),

    K084("师徒体系活动配置缓存"),
    K085("师徒体系兑吧活动id对应的活动配置id"),
    K086("师徒体系活动预算今日报警次数"),

	K090("陌陌推送登陆用户"),
	K091("陌陌推送未领奖用户"),

	K092("多游戏排名中一个分榜信息对应的配置项id"),
	K093("多游戏排行榜分榜维度数据集"),
	K094("多游戏排行榜分榜最后一名分数"),
	K095("多游戏排行榜分榜维度次数序列-用于同分排序"),

	K096("app当月游戏中心配置的总金额"),

	K100("新游戏中心配置缓存"),
	K101("新游戏中心定向缓存"),
	K102("新游戏中心赛季缓存"),

	K109("预算配置按配置id查询配置"),
	K110("种红包当前用户剩余可中红包次数"),
	K111("种红包当前用户剩余可种植红包次数"),

	K120("拼团按拼团id获取团信息"),
	K121("拼团按拼团id列表批量获取拼团信息"),
	K122("拼团按拼团商品id和状态批量获取团信息"),
	K123("拼团按appId、拼团活动配置id、状态批量获取团信息"),
	K124("拼团活动配置"),
	K125("拼团根据自定义活动id(列表)拼团活动配置"),
	K126("拼团根据自定义活动id(详情)拼团活动配置"),
	K127("根据假用户id列表批量获取假用户信息"),
	K128("拼团根据商品id获取拼团商品"),
	K129("拼团根据商品id列表批量获取拼团商品"),
	K130("拼团按商品id列表和状态批量获取团信息"),
	K131("拼团按团id和用户id获取用户参团记录"),
	K132("PK开奖消息是否消费"),

	K133("书旗pk战队信息"),
	K135("书旗pk用户信息"),
	K136("书旗pk战队用户信息"),
	K137("书旗pk战队某天pk记录"),
	K138("书旗pk战队历史所有pk记录"),
	K139("书旗pk战队用户某天阅读值记录"),
	K140("书旗pk战队pk记录对应的用户记录"),
	K141("书旗pk战队匹配插入pk记录锁"),
	K142("书旗组队pk战队排行榜"),
	K143("书旗pk同步阅读值锁"),

	/**pk赛控制是否 今日是否需要重新标记---该控制必须在标记发放完之后，才会重新排列  string 结构 有效时间跟随pk赛周期**/
	K144("pkUnitAwardTagUpdate"),
	/**pk赛标记用户 hash结构：pkUnitAwardTag_活动组id_appid {consumerid : 上次押注时间}，有效时间跟随pk赛周期**/
	K145("pkUnitAwardTag"),
	/**pk赛参与人的结算金额排名 zset结构  数据个数在pk赛中奖人数限制的2倍**/
	K146("pkUserOwnMoneySort"),
	/**pk赛参与人数  string 结构 有效时间跟随pk赛周期**/
    K147("pkJoinUser"),
	/**	用于控制刚开始前（可提现个数）用户拿到标记，从而正常显示题目 **/
	K148("pkJoinUserLimitTag"),

	K150("红包广场当前方法总预算"),
	K151("红包广场奖励配置"),
	K152("红包广场梯度奖励位置"),
	K153("红包广场基础配置"),

    K155("猜红包,用户拆红包记录"),
    K156("猜红包,红包被猜记录"),
	K157("猜红包,用户猜红包记录"),

	K162("书旗组队pk当天阅读值同步标记"),
	K163("书旗组队pk同步阅读值消息锁"),
	K164("书旗组队pk战队匹配消息锁"),

	K165("拼拼乐拼团活动拼团商品每日成团数"),
	K166("拼拼乐拼团活动配置-app端"),
	K167("拼拼乐根据拼团活动配置id获取拼团商品列表"),
	K168("拼拼乐根据商品id获取拼团商品"),
	K169("拼拼乐根据拼团id获取团信息"),
	K170("拼拼乐根据拼团id获取团长id"),
	K171("拼拼乐根据拼团id和人数获取团员id"),
	K173("拼拼乐拼团活动基础配置-app端"),
	K174("拼拼乐拼团活动配置-开发者后台"),
	K175("拼拼乐团过期失败处理锁"),

	K176("0元拼团工具活动配置-app端"),
	K178("0元拼团工具活动配置-开发者后台"),
	K179("0元拼团工具根据活动id获取拼团商品列表"),
	K180("0元拼团工具根据商品id获取拼团商品"),

	/**
	 * 18开头:新版开心码活动占用
	 */
	K181("新版开心码活动最新参与用户ID列表"),
	K182("新版开心码活动最新获奖用户ID列表"),
	K183("新版开心码活动-活动下正在进行的赛事"),
	K184("新版开心码活动-期次信息"),
	K186("新版开心码活动-赛事信息"),
	K187("新版开心码活动-开发者后台活动信息"),
	K188("积分夺宝-推送参与消息"),


	K191("微信刮红包用户红包信息详情缓存"),
	K192("微信刮红包用户红包帮刮记录缓存"),
	K193("微信刮红包新用户帮刮与否"),

	/**
	 * 挖矿机活动
	 */
	K200("挖矿机总投入积分"),
	K201("挖矿机总消耗积分"),
	K202("挖矿机总发放积分"),
	K203("挖矿机用户维度当天参与次数"),
	K204("挖矿机参与总次数"),
	K205("挖矿机参与总人数"),
	K206("挖矿机中奖弹幕"),
	;

	/**
	 * 应用名称
	 */
	private static final String SPACE = "AC";

	private String desc;

	RedisKeySpace(String description) {
		this.desc = description;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 拼接key前置
	 */
	@Override
	public String toString() {
		return SPACE + "_" + super.toString() + "_";
	}

}
