package cn.com.duiba.activity.center.api.remoteservice.creditsfarm;


import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmSaleRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * created by liugq in 2019/08/05
 * 果实兑换记录
 */
@AdvancedFeignClient
public interface RemoteCreditsFarmSaleRecordService {

    CreditsFarmSaleRecordDto findById(Long id);

    /**
     * 查询此兑换类型下用户的出售次数
     * @param consumerId
     * @param actId
     * @param exchangeType
     * @return
     */
    Integer countBySeedAndType(Long consumerId, Long actId, Long seedId, Integer exchangeType);

    /**
     * 处理加积分处理会调
     * @param orderNum：加积分订单号
     * @param result ： 开发者返回的结果
     * @return
     */
    Boolean dealAfterAddCreditsCallBack(String orderNum, Boolean result);

    /**
     * 查询用户此活动下的出售记录
     * @param consumerId
     * @param actId
     * @return
     */
    List<CreditsFarmSaleRecordDto> selectByConsumerAndAct(Long consumerId, Long actId);

    Long insert(CreditsFarmSaleRecordDto dto);

    /**
     * 根据订单号修改状态
     * @param consumerId
     * @param orderNum
     * @param exchangeStatus : 0- 初始化 1-成功 2-失败
     * @return
     */
    Integer updateByOrderNum(Long consumerId, String orderNum, Integer exchangeStatus);

    /**
     * 根据id更新订单号
     * 并将兑换状态更新为成功
     * @param id
     * @param orderNum
     * @return
     */
    Integer updateOrderNumById(Long id, String orderNum);

    /**
     * 更新兑换状态
     * @param id
     * @param exchangeStatus
     * @return
     */
    Integer updateByRecordId(Long id, Integer exchangeStatus);
}
