package cn.com.duiba.activity.center.api.remoteservice.lotterysquare;

import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareBonusRecordDto;
import cn.com.duiba.activity.center.api.enums.LSExchangeStatusEnum;
import cn.com.duiba.activity.center.api.params.LotterySquareRecordQueryParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author chenxiangge
 * @Date 2018/12/17
 */
@AdvancedFeignClient
public interface RemoteLotterySquareRecordService {
    Long insert(LotterySquareBonusRecordDto lotterySquareBonusRecordDto);

    int update(LotterySquareBonusRecordDto lotterySquareBonusRecordDto);

    /**
     * 根据条件查询奖励记录（状态非失败）
     * @param param
     * @return
     */
    Integer countBonusRecordByParam(LotterySquareRecordQueryParam param);

    Page<LotterySquareBonusRecordDto> selectBonusListRecordByPage(LotterySquareRecordQueryParam param);

    int updateExchangeStatus(Long recordId, LSExchangeStatusEnum exchangeStatus);

    int setBonusRecordToRead(Long recordId);

    Long getTotalSendBonus(Long activityId);

    /**
     * 获取用户在某一活动获得总奖励
     *
     * @param activityId
     * @param consumerId
     * @return
     */
    Long getConsumerTotalBonus(Long activityId, Long consumerId);

    LotterySquareBonusRecordDto findById(Long id);

    int batchUpdateRead(List<Long> ids);

    /**
     * 获取梯度/首次分享未读奖励
     * @param activityId
     * @param consumerId
     * @return
     */
    List<LotterySquareBonusRecordDto> selectUnReadBonusRecord(Long activityId, Long consumerId);
}
