package cn.com.duiba.activity.center.api.mqmessage;

import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * @author: zhengjianhao
 * @date: 2019/1/29 11:51
 * @description:
 */
public class ShuQiTeamMatchMessage implements Serializable{

	private static final long serialVersionUID = -4499266024312090739L;

	private Long teamId;

    private Long enemyTeamId;

    private Long recordDate;

	public Long getTeamId() {
		return teamId;
	}

	public void setTeamId(Long teamId) {
		this.teamId = teamId;
	}

	public Long getEnemyTeamId() {
		return enemyTeamId;
	}

	public void setEnemyTeamId(Long enemyTeamId) {
		this.enemyTeamId = enemyTeamId;
	}

	public Long getRecordDate() {
		return recordDate;
	}

	public void setRecordDate(Long recordDate) {
		this.recordDate = recordDate;
	}

	public static ShuQiTeamMatchMessage decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return JSONObject.parseObject(string, ShuQiTeamMatchMessage.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(ShuQiTeamMatchMessage msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
