package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.javatuples.Triplet;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 活动工具订单业务Service
 */
@AdvancedFeignClient
public interface RemoteHdtoolOrdersService {

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询订单
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public HdtoolOrdersDto find(Long id);

	/**
	 * 
	 * findInOrderIds:(这里用一句话描述这个方法的作用). <br/>
	 * 根据活动主订单ID集合查询订单信息
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<HdtoolOrdersDto> findInOrderIds(List<Long> ids);

	/**
	 * 
	 * findExpireOrder:(这里用一句话描述这个方法的作用). <br/>
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 * @return
	 * @since JDK 1.6
	 */
	public List<HdtoolOrdersDto> findExpireOrder();


	/**
	 * 查询制定日期范围过期的
	 * @param subDay
	 * @return
	 */
	List<HdtoolOrdersDto> findExpireOrderBySubDay(Integer subDay,List<Long> appIds);
	
	
	/**
	 * 
	 * createOrder:(创建订单  先给用户 增加活动参与次数  添加成功后 在创建子订单 活动web调用活动中心次数). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<HdtoolOrdersDto> createOrder(HdtoolOrdersDto hdtoolOrdersDto);
	
	/**
	 * 
	 * createOrder:(查询订单及活动信息 减少  活动web调用活动中心次数). <br/>
	 * 
	 * @param consumerId
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DubboResult<Triplet<OperatingActivityDto,DuibaHdtoolDto,HdtoolOrdersDto>> findActivtyAndOrderInfo(Long consumerId, Long id);


	/**
	 * 根据活动id,奖品类型，创建时间，查询活动订单
	 * @param operatingActivityId
	 * @param gmtCreate
	 * @param types
	 * @return
	 */
	List<HdtoolOrdersDto> findOrdersByPrizeTypeAndOperatingActivityId(Long operatingActivityId, Date gmtCreate, Set<String> types, Integer number, List<String> prizeIds);


}
