package cn.com.duiba.activity.center.api.remoteservice.scraperedpacket;

import cn.com.duiba.activity.center.api.dto.scraperedpacket.ScrapeRedPacketDto;
import cn.com.duiba.activity.center.api.params.ScrapeRedPacketWinnerParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteScrapeRedPacketService {

    /**
     * 新增微信刮红包活动配置
     * 会同步创建入库活动
     * 返回 刮红包活动id
     * @param dto
     * @return
     */
    ScrapeRedPacketDto insert(ScrapeRedPacketDto dto);

    /**
     * 修改卫星刮红包活动配置
     * 会同步更新入库活动
     * @param dto
     * @return
     */
    int update(ScrapeRedPacketDto dto);

    /**
     * 根据刮红包活动id查询刮红包活动配置
     * @param id
     * @return
     */
    ScrapeRedPacketDto findById(Long id);

    /**
     * 根据入库活动id 查询刮红包活动配置
     * @param operatingActivityId
     * @return
     */
    ScrapeRedPacketDto findByOperatingActivityId(Long operatingActivityId);

    /**
     * 会同步删除入库活动
     * 只要删除刮红包成功 就会返回true
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据活动id查询虚拟弹幕信息
     * 优先返回真实数据 一共返回50条
     * 若真实数据不足50条 填充虚假数据
     * @return
     */
    List<ScrapeRedPacketWinnerParam> findWinnersByOperatingActivityId(Long operatingActivityId);

}
