package cn.com.duiba.activity.center.api.dto.guessredpacket;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhengjianhao
 * @date 18/7/26
 * @description 猜红包-红包信息
 */
public class GuessRedPacketInfoDto implements Serializable {

	private static final long serialVersionUID = 7081002983498536204L;

	/**
	 * 红包id
	 */
	private Long redPacketId;

	/**
	 * 红包金额：以分为单位
	 */
	private Long amount;

	/**
	 * 红包金额区间下限：以分为单位
	 */
	private Long bonusMin;

	/**
	 * 红包金额区间上限：以分为单位
	 */
	private Long bonusMax;

	/**
	 * 状态：1，未被猜中，仍可被猜；2，已被猜中；3，被猜次数已满
	 * @see cn.com.duiba.activity.center.api.enums.GuessRedPacketStatusEnum
	 */
	private Integer status;

	/**
	 * 红包持有者id
	 */
	private Long ownerConsumerId;

	/**
	 * 猜中人id
	 */
	private Long guessedConsumerId;

	/**
	 * 开发者用户id
	 */
	private String partnerUserId;

	/**
	 * 创建时间
	 */
	private Date createTime;

	public Long getRedPacketId() {
		return redPacketId;
	}

	public void setRedPacketId(Long redPacketId) {
		this.redPacketId = redPacketId;
	}

	public Long getAmount() {
		return amount;
	}

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getBonusMin() {
		return bonusMin;
	}

	public void setBonusMin(Long bonusMin) {
		this.bonusMin = bonusMin;
	}

	public Long getBonusMax() {
		return bonusMax;
	}

	public void setBonusMax(Long bonusMax) {
		this.bonusMax = bonusMax;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getGuessedConsumerId() {
		return guessedConsumerId;
	}

	public void setGuessedConsumerId(Long guessedConsumerId) {
		this.guessedConsumerId = guessedConsumerId;
	}

	public Long getOwnerConsumerId() {
		return ownerConsumerId;
	}

	public void setOwnerConsumerId(Long ownerConsumerId) {
		this.ownerConsumerId = ownerConsumerId;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}
}
