package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityWhiteListDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @program: activity-all
 * @description: 权益批次
 * @author: liukai
 * @create: 2019-12-02 11:43
 **/
@AdvancedFeignClient
public interface RemoteEquityWhiteListService {

    Integer deleteByBatchIds(List<Long> ids);

    Integer batchInsert(List<EquityWhiteListDto> equityWhiteListDtos);

    Integer updateStatusById(Integer status,Long id);

    /**
     * 只返回一条数据！！！！
     * @param appId
     * @param equityId
     * @param relType
     * @param relValue
     * @return
     */
    EquityWhiteListDto getByAidEidRtypeRval(Long appId,Long equityId,Integer relType,String relValue);

    List<EquityWhiteListDto> getByAidEidRtypeRvals(Long appId, Long equityId, Integer relType, List<String> relValues);

    List<EquityWhiteListDto> getByAidRelValueAndRelStatus(Long appId, Long equityId, Integer relType, List<String> relValues, Integer relStatus);

    List<EquityWhiteListDto> getByAidRtypeRval(Long appId, Integer relType, String relValue);

    List<EquityWhiteListDto> listByEquityIdAndRelType(Long equityId,Long appId, Integer relType);

    Integer deleteByEquityId(List<Long> ids);

}

