package cn.com.duiba.activity.center.api.remoteservice.managermarket;

import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketBackendConfigDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketOrganDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffAllDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffExtDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description: 客户经理营销中心 接口
 * @Date: Created in 2020/8/6
 */
@AdvancedFeignClient
public interface RemoteManagerMarketService {

    /**
     * ====================B端接口=======================
     */
    /**
     * 通过主键id获取（cms管理后台使用）
     * @param id
     * @return
     */
    ManagerMarketBackendConfigDto getBackendConfig(Long id);

    /**
     * 保存活动
     * @param dto
     * @return
     */
    Long saveConfig(ManagerMarketBackendConfigDto dto);

    /**
     * 批量保存员工
     * @param list
     * @return
     */
    boolean batchSaveStaff(List<ManagerMarketStaffDto> list);

    /**
     * 删除员工
     * @param configId 活动主键id
     * @return
     */
    boolean deleteStaff(Long configId);

    /**
     * 批量保存机构
     * @param list
     * @return
     */
    boolean batchSaveOrgan(List<ManagerMarketOrganDto> list);

    /**
     * 删除机构
     * @param configId 活动主键id
     * @return
     */
    boolean deleteOrgan(Long configId);

    /**
     * 更改置顶状态
     * @param id
     * @param toppingSwitch
     * @param toppingTime
     * @return
     */
    boolean updateTopping(Long id, boolean toppingSwitch, Date toppingTime);




    /**
     * ====================C端接口=======================
     */

    /**
     * 通过活动配置id获取所有机构
     * @param configId
     * @return
     */
    List<ManagerMarketOrganDto> getAllOrganByConfigId(Long configId);

    /**
     * 通过配置id和手机号查询 员工所有信息（包括所在机构等）
     * @param configId
     * @param phone
     * @return
     */
    ManagerMarketStaffAllDto getStaffAllByConfigIdAndPhone(Long configId, String phone);

    /**
     * 通过配置id和手机号查询员工信息
     * @param configId
     * @param phone
     * @return
     */
    ManagerMarketStaffDto selectByConfigIdAndPhone(Long configId, String phone);

    /**
     * 通过配置id和机构编号查询
     * @param configId
     * @param number
     * @return
     */
    ManagerMarketOrganDto selectByConfigIdAndNumber(Long configId, String number);

    /**
     * 录入员工额外信息
     * @param dto
     * @return
     */
    boolean enterStaff(ManagerMarketStaffExtDto dto);

    /**
     * 通过主键id获取员工额外信息
     * @param id
     * @return
     */
    ManagerMarketStaffExtDto getStaffExtById(Long id);

}
