package cn.com.duiba.activity.center.api.remoteservice.managermarket;

import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketBackendConfigDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketConfigDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketOrganDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketRankDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffAllDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffExtDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStaffScoreDetailDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketTaskDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description: 客户经理营销中心 接口
 * @Date: Created in 2020/8/6
 */
@AdvancedFeignClient
public interface RemoteManagerMarketService {

    /**
     * ====================B端接口=======================
     */
    /**
     * 通过主键id获取（cms管理后台使用）
     * @param id
     * @return
     */
    ManagerMarketBackendConfigDto getBackendConfig(Long id);

    /**
     * 保存活动
     * @param dto
     * @return
     */
    Long saveConfig(ManagerMarketBackendConfigDto dto);

    /**
     * 批量保存员工
     * @param list
     * @return
     */
    boolean batchSaveStaff(List<ManagerMarketStaffDto> list);

    /**
     * 删除员工
     * @param configId 活动主键id
     * @return
     */
    boolean deleteStaff(Long configId);

    /**
     * 批量保存机构
     * @param list
     * @return
     */
    boolean batchSaveOrgan(List<ManagerMarketOrganDto> list);

    /**
     * 删除机构
     * @param configId 活动主键id
     * @return
     */
    boolean deleteOrgan(Long configId);

    /**
     * 更改置顶状态
     * @param id
     * @param toppingSwitch
     * @param toppingTime
     * @return
     */
    boolean updateTopping(Long id, boolean toppingSwitch, Date toppingTime);




    /**
     * ====================C端接口=======================
     */

    /**
     * 通过主键id获取活动信息
     * @param id
     * @return
     */
    ManagerMarketConfigDto getConfigById(Long id);

    /**
     * 通过活动id获取任务列表
     * @param configId
     * @return
     */
    List<ManagerMarketTaskDto> listTaskByConfigId(Long configId);

    /**
     * 通过活动配置id获取所有机构
     * @param configId
     * @return
     */
    List<ManagerMarketOrganDto> getAllOrganByConfigId(Long configId);

    /**
     * 通过配置id和编号查询 员工所有信息（包括所在机构等）
     * @param configId
     * @param number
     * @return
     */
    ManagerMarketStaffAllDto getStaffAllByConfigIdAndNumber(Long configId, String number);

    /**
     * 通过配置id和手机号查询 员工所有信息（包括所在机构等）
     * @param configId
     * @param phone
     * @return
     */
    ManagerMarketStaffAllDto getStaffAllByConfigIdAndPhone(Long configId, String phone);

    /**
     * 通过配置id和手机号查询员工信息
     * @param configId
     * @param phone
     * @return
     */
    ManagerMarketStaffDto selectByConfigIdAndPhone(Long configId, String phone);

    /**
     * 通过配置id和机构编号查询
     * @param configId
     * @param number
     * @return
     */
    ManagerMarketOrganDto selectByConfigIdAndNumber(Long configId, String number);

    /**
     * 录入员工额外信息
     * @param dto
     * @return
     */
    boolean enterStaff(ManagerMarketStaffExtDto dto);

    /**
     * 通过主键id获取员工额外信息
     * @param id
     * @return
     */
    ManagerMarketStaffExtDto getStaffExtById(Long id);

    /**
     * 通过配置主键id和员工编号查询
     * @param configId
     * @param staffNumber
     * @return
     */
    ManagerMarketStaffExtDto getStaffExtByConfigIdAndStaffNumber(Long configId, String staffNumber);

    /**
     * 通过配置id和员工编号查询
     * @param configId
     * @param staffNumber
     * @return
     */
    List<ManagerMarketStaffScoreDetailDto> listByConfigIdAndStaffNumber(Long configId, String staffNumber);

    /**
     * 保存用户分数记录
     * @param dto
     * @return
     */
    Long saveStaffScoreDetail(ManagerMarketStaffScoreDetailDto dto);

    /**
     * 创建排行榜
     * @param dto
     * @return
     */
    Long saveRank(ManagerMarketRankDto dto);

    /**
     * 通过活动id和员工编号查询排行榜信息（员工排行榜）
     * @param configId
     * @param staffNumber
     * @return
     */
    List<ManagerMarketRankDto> selectByConfigIdAndStaffNumber(Long configId, String staffNumber);

    /**
     * 通过活动id和机构编号查询排行榜信息（机构排行榜）
     * @param configId
     * @param organNumber
     * @return
     */
    List<ManagerMarketRankDto> selectByConfigIdAndOrganNumber(Long configId, String organNumber);

    /**
     * 修改排行榜数据
     * @param id
     * @param incrScore 添加的分数
     * @param opType 操作类型。1：转发微信好友，2：转发朋友圈，3：活动被打开，4：活动绑定 StaffOpTypeEnum
     * @return
     */
    boolean incrTotalScoreByOpType(Long id, int incrScore, int opType);

    /**
     * 获取排行榜列表
     * @param rankTime 排行榜时间
     * @param rankLatitudeType 排行榜纬度 个人/机构
     * @param pageSize
     * @param pageNo
     * @return
     */
    List<ManagerMarketRankDto> listRankByLatitudeType(String rankTime, Integer rankLatitudeType, Integer pageSize, Integer pageNo);

    /**
     * 获取比这分数高的，或者等于这个分数但是时间更早的排行榜个数
     * @param rankTime 排行榜期次时间
     * @param totalScore 分数
     * @param time 更新时间
     * @param organNumber 机构编号，不填表示全部排名，填了表示在机构内排名
     * @return
     */
    int getCountByTotalScoreAndTime(String rankTime, Long totalScore, Date time, String organNumber);

}
