package cn.com.duiba.activity.center.api.params.activitychannel;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * <p>活动渠道配置</p>
 * <p>created by Xuwei on 2021/4/12<p>
 **/
public class ActivityChannelConfigParam implements Serializable {

    private static final long serialVersionUID = 3393805408780267235L;

    /** APP渠道配置 */
    private AppChannelParam app;
    /** 微信公众号渠道配置 */
    @JSONField(name = "oa")
    private OfficialAccountChannelParam officialAccount;
    /** 微信小程序渠道配置 */
    @JSONField(name = "mp")
    private MiniProgramChannelParam miniProgram;

    /**
     * 设置默认值，校验参数合法性
     * @throws BizException
     */
    public void setDefaultAndCheck() throws BizException {

        if (hasApp()) {
            setAppDefault();
            app.check();
        }
        if (hasOfficialAccount()) {
            officialAccount.check();
        }
        if (hasMiniProgram()) {
            miniProgram.check();
        }
    }

    /**
     * 设置app默认值
     */
    private void setAppDefault() {
        if (app.getShareUrlType() == null) {
            if (officialAccount != null) {
                app.setShareUrlType(AppChannelParam.OFFICIAL_ACCOUNT);
            } else if (miniProgram != null) {
                app.setShareUrlType(AppChannelParam.MINI_PROGRAM);
            }
        } else if (officialAccount == null && miniProgram == null) {
            app.setShareUrlType(null);
        } else if (miniProgram == null) {
            app.setShareUrlType(AppChannelParam.OFFICIAL_ACCOUNT);
        } else if (officialAccount == null) {
            app.setShareUrlType(AppChannelParam.MINI_PROGRAM);
        }
    }

    /**
     * 是否包含app
     * @return
     */
    public boolean hasApp() {
        return app != null && app.isSelected();
    }

    /**
     * 是否包含微信公众号
     * @return
     */
    public boolean hasOfficialAccount() {
        return officialAccount != null && officialAccount.isSelected();
    }

    /**
     * 是否包含微信小程序
     * @return
     */
    public boolean hasMiniProgram() {
        return miniProgram != null && miniProgram.isSelected();
    }

    public AppChannelParam getApp() {
        return app;
    }

    public void setApp(AppChannelParam app) {
        this.app = app;
    }

    public OfficialAccountChannelParam getOfficialAccount() {
        return officialAccount;
    }

    public void setOfficialAccount(OfficialAccountChannelParam officialAccount) {
        this.officialAccount = officialAccount;
    }

    public MiniProgramChannelParam getMiniProgram() {
        return miniProgram;
    }

    public void setMiniProgram(MiniProgramChannelParam miniProgram) {
        this.miniProgram = miniProgram;
    }

    public static void main(String[] args) {
        ActivityChannelConfigParam param = new ActivityChannelConfigParam();
        param.setApp(new AppChannelParam());
        param.setOfficialAccount(new OfficialAccountChannelParam());
        param.setMiniProgram(new MiniProgramChannelParam());

        JSONObject json = new JSONObject();
        json.put("channelConfig", param);
        System.out.println(json.toJSONString());

        json = JSON.parseObject(json.toJSONString());
        param = json.getObject("channelConfig", param.getClass());

        System.out.println(JSON.toJSONString(param));
    }
}
