package cn.com.duiba.activity.center.api.remoteservice.seconds_kill;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.activity.ActivityItemDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 
 * ClassName: RemoteDuibaSecondsKillActivityServiceNew <br/>
 * date: 2016年12月1日 下午5:39:06 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaSecondsKillActivityServiceNew {

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
	public DuibaSecondsKillActivityDto find(Long id);

	/**
	 * 
	 * findTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public String findTagById(Long id);
	
	/**
	 * 
	 * findAllDuibaSecondKillByAppId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	public List<AddActivityDto> findAllDuibaSecondKillByAppId(Long appId);

	/**
	 * 
	 * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ids
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSecondsKillActivityDto> findAllByIds(List<Long> ids);

	/**
	 * 
	 * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSecondsKillActivityDto> findAutoOff();

	/**
	 * 
	 * changeStatus:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param status
	 * @since JDK 1.6
	 */
	public void changeStatus(Long id, Integer status);


	/**
	 * 
	 * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public int updateAutoOffDateNull(Long id);
	/**
	 * 
	 * updateTagById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param tag
	 * @return
	 * @since JDK 1.6
	 */
	public int updateTagById(Long id, String tag);
	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaSecondsKillActivityDO
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaSecondsKillActivityDto insert(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	/**
	 * 
	 * findByPage:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param params
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaSecondsKillActivityDto> findByPage(Map<String, Object> params);

	/**
	 * 
	 * count:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public int count();

	/**
	 * 
	 * count:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param params
	 * @return
	 * @since JDK 1.6
	 */
	@RequestMapping("/count1")
	public int count(Map<String, Object> params);

	/**
	 * 
	 * deleteById:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	public void deleteById(Long id);

	/**
	 * 
	 * updateSwitches:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param switches
	 * @since JDK 1.6
	 */
	public void updateSwitches(Long id, Long switches);

	/**
	 * 
	 * update:(这里用一句话描述这个方法的作用). <br/>
	 * @param duibaSecondsKillActivityDO
	 * @since JDK 1.6
	 */
	public void update(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);


	//from DuibaSecondsKillService

	/**
	 * 后台关闭并且下架专题活动
	 */
	public DubboResult<DuibaSecondsKillActivityDto> closeAndUnViewDuibaActivity(Long id);

	/**
	 * 添加活动到开发者运营活动,from developer,因为方法名冲突,所以加入_developer后缀
	 */
	public DubboResult<Long> addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview) ;

	/**
	 * 添加活动到开发者运营活动
	 */
	public DubboResult<Long> addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview) ;

	//from DuibaSecondsKillActivityService

	/**
	 * 后台创建兑吧秒杀专题-创建权限
	 */
	public DubboResult<Void> createDuibaSecondKillActivity(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	/**
	 * 后台更新兑吧秒杀专题-更新权限
	 */
	public DubboResult<Void> updateDuibaSecondKillActivity(DuibaSecondsKillActivityDto duibaSecondsKillActivityDO);

	//from DuibaSecondsKillActivityService in manager and from from DuibaSeckillServiceImpl
	/**
	 * 添加秒杀专题活动的子活动到开发者活动中
	 */
	public DubboResult<Void> addChildrenActivityToDeveloper(DuibaSecondsKillActivityDto duibaActivity, Long operatingActivityId, Long appId);


	//from AdminDuibaSecondsKillActivityManagerImpl

	public DubboResult<DuibaSecondsKillActivityDto> deleteDuibaSecondsKillActivity(Long id);

	public DubboResult<DuibaSecondsKillActivityDto> closeDuibaSecondsKillActivity(Long id);

	public DubboResult<Void> startupDuibaSecondsKillActivity(Long id);

	public DubboResult<DuibaSecondsKillActivityDto> closeAndUnViewDuibaSecondsKillActivity(Long id);

	public DubboResult<Void> addDuibaSecondsKillActivityAppSpecify(Long id, String[] appIds);

	public DubboResult<List<ActivityItemDto>> showSecondKillItemList(Long id, Long appId);
	
	/**
	 * 查询开启状态的秒杀专题
	 *
	 * @author zhanglihui
	 * @return 秒杀专题
	 */
	DubboResult<List<DuibaSecondsKillActivityDto>> findEnableActivityList();
}

