package cn.com.duiba.activity.center.api.remoteservice.creditsfarm;


import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmCropDetailDto;
import cn.com.duiba.activity.center.api.dto.creditsfarm.CreditsFarmNutritionRecordDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * created by liugq in 2019/08/05
 * 营养液流水服务
 */
@AdvancedFeignClient
public interface RemoteCreditsFarmNutritionRecordService {

    /**
     * 使用营养液
     * @param cropDetailDto 使用该营养液的种植记录
     * @param dto
     * @return 返回增加的收益（mg）
     */
    Integer useNutrition(CreditsFarmCropDetailDto cropDetailDto, CreditsFarmNutritionRecordDto dto);


    /**
     * 增加营养液
     * @param dto
     * @return
     */
    Boolean addNutrition(CreditsFarmNutritionRecordDto dto);

    /**
     * 查询用户今天获得的奖励次数
     * @param consumerId
     * @param actId
     * @param taskType 任务类型，可为空
     * @return
     */
    Integer countTodayReward(Long consumerId, Long actId, Integer taskType);

    /**
     * 分页查询
     * @param consumerId
     * @param actId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<CreditsFarmNutritionRecordDto> pageQuery(Long consumerId, Long actId, int pageNo, int pageSize);

}
