package cn.com.duiba.activity.center.api.remoteservice.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NGameInnerJoinRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hww on 2018/1/24 下午4:01.
 */
@AdvancedFeignClient
public interface RemoteNGameInnerJoinRecordService {

    /**
     * 插入一条记录
     * @param nGameInnerJoinRecordDto
     * @return
     */
    Long insert(NGameInnerJoinRecordDto nGameInnerJoinRecordDto);

    /**
     * 根据子订单id和用户id查询对应的中间记录
     * @param orderId
     * @param consumerId
     * @return
     */
    NGameInnerJoinRecordDto findByOrderIdAndConsumerId(Long orderId, Long consumerId);

    /**
     * 一般性的更新方法,更新三个字段
     * times字段必传,且必须与数据库值相同
     * 不指定或者指定与数据库值不符,会更新失败
     * score; 不为空则更新数据库的值
     * dynamicData; 不为空则更新数据库的值
     * recordStatus; 不为空则更新数据库的值
     * @param nGameInnerJoinRecordDto
     * @return
     */
    Integer generalUpdate(NGameInnerJoinRecordDto nGameInnerJoinRecordDto);

    /**
     * 根据游戏id和用户id查询所有处理中的交互记录
     * @param gameId
     * @param consumerId
     * @return
     */
    List<NGameInnerJoinRecordDto> findAllProcessingByGameIdAndConsumerId(Long gameId, Long consumerId);


    /**
     * 根据记录id批量修改订单状态为完成状态
     * @param ids
     * @return
     */
    int updateStatus2FinishBatch(List<Long> ids);



}
