/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.dto.activity.CLRewardDto;
import cn.com.duiba.activity.center.api.dto.activity.CLRuleDto;
import cn.com.duiba.activity.center.api.enums.CLRewardRuleMatchEnum;
import cn.com.duiba.api.enums.CardActAppTypeEnum;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class CLCardConfigDto
extends BaseDto {
    private static final long serialVersionUID = -9206704999666861311L;
    private Long id;
    private String clName;
    private List<CLRuleDto> rules = Collections.emptyList();
    private List<CLRewardDto> rewards = Collections.emptyList();
    private Boolean autoReward;
    private Integer rewardLimit;
    private JSONObject extra;
    private Boolean deleted;
    private Integer clcardType = 0;
    private Date gmtCreate;
    private Date gmtModified;
    private CardActAppTypeEnum appType;

    public CLRewardDto getMatchGrade(List<CLRewardDto.Entry> entries) {
        if (CollectionUtils.isEmpty(entries) || CollectionUtils.isEmpty(this.rewards)) {
            return null;
        }
        for (CLRewardDto dto : this.rewards) {
            if (!this.matchValid(dto, entries)) continue;
            return dto;
        }
        return null;
    }

    public CLRewardDto getMatchGrade(List<CLRewardDto.Entry> entries, Integer grade) {
        if (CollectionUtils.isEmpty(entries)) {
            return null;
        }
        if (grade != null) {
            for (CLRewardDto dto : this.rewards) {
                if (!dto.getGrade().equals(grade) || !this.matchValid(dto, entries)) continue;
                return dto;
            }
            return null;
        }
        return this.getMatchGrade(entries);
    }

    public List<CLRewardDto> getMatchGradeList(List<CLRewardDto.Entry> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<CLRewardDto> rewardList = new ArrayList<CLRewardDto>();
        for (CLRewardDto dto : this.rewards) {
            if (!this.matchValid(dto, entries)) continue;
            rewardList.add(dto);
        }
        return rewardList;
    }

    public boolean matchValid(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        if (CLRewardRuleMatchEnum.ALL_MATCH.equals((Object)reward.getMatchType())) {
            return this.allMatchValid(reward, entries);
        }
        if (CLRewardRuleMatchEnum.RANDOM_MATCH.equals((Object)reward.getMatchType())) {
            return this.randomMatchValid(reward, entries);
        }
        return false;
    }

    private boolean randomMatchValid(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        for (CLRewardDto.Entry entry : entries) {
            paramMap.put(entry.getKey(), entry.getVal());
        }
        int i = 0;
        for (CLRuleDto dto : this.rules) {
            Integer val = (Integer)paramMap.get(String.valueOf(dto.getId()));
            if (val <= 0 || ++i < reward.getEntryCount()) continue;
            return true;
        }
        return false;
    }

    private boolean allMatchValid(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        for (CLRewardDto.Entry entry : entries) {
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for (CLRewardDto.Entry rule : reward.getMatchs()) {
            Integer val = (Integer)paramMap.get(rule.getKey());
            if (val != null && val >= rule.getVal()) continue;
            return false;
        }
        return true;
    }

    public void matchDeduct(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        if (CLRewardRuleMatchEnum.ALL_MATCH.equals((Object)reward.getMatchType())) {
            this.allMatchDeduct(reward, entries);
        } else if (CLRewardRuleMatchEnum.RANDOM_MATCH.equals((Object)reward.getMatchType())) {
            this.randomMatchDeduct(entries);
        }
    }

    private void randomMatchDeduct(List<CLRewardDto.Entry> entries) {
        for (CLRewardDto.Entry rule : entries) {
            rule.setVal(rule.getVal() - 1);
        }
    }

    private void allMatchDeduct(CLRewardDto reward, List<CLRewardDto.Entry> entries) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        for (CLRewardDto.Entry entry : reward.getMatchs()) {
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for (CLRewardDto.Entry rule : entries) {
            Integer val = (Integer)paramMap.get(rule.getKey());
            if (val == null) continue;
            rule.setVal(rule.getVal() - val);
        }
    }

    public Map<Integer, Integer> getMatchGradeMap(List<CLRewardDto.Entry> entries) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        List entriesCopy = BeanUtils.copyList(entries, CLRewardDto.Entry.class);
        for (CLRewardDto dto : this.rewards) {
            int matchCount = 0;
            while (this.matchValid(dto, entriesCopy)) {
                ++matchCount;
                this.matchDeduct(dto, entriesCopy);
            }
            result.put(dto.getGrade(), matchCount);
        }
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClName() {
        return this.clName;
    }

    public void setClName(String clName) {
        this.clName = clName;
    }

    public List<CLRuleDto> getRules() {
        return this.rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardDto> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<CLRewardDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getAutoReward() {
        return this.autoReward;
    }

    public void setAutoReward(Boolean autoReward) {
        this.autoReward = autoReward;
    }

    public Integer getRewardLimit() {
        return this.rewardLimit;
    }

    public void setRewardLimit(Integer rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public JSONObject getExtra() {
        return this.extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getClcardType() {
        return this.clcardType;
    }

    public void setClcardType(Integer clcardType) {
        this.clcardType = clcardType;
    }

    public CardActAppTypeEnum getAppType() {
        return this.appType;
    }

    public void setAppType(CardActAppTypeEnum appType) {
        this.appType = appType;
    }
}

