package cn.com.duiba.activity.center.api.remoteservice.seedredpacket;

import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import javax.annotation.CheckForNull;

/**
 * @author zhengjianhao
 * @date 18/7/5
 * @description
 */
@AdvancedFeignClient
public interface RemoteAppSeedRedPacketService {

	SeedRedPacketDto getById(Long id);

	/**
	 * 查询appId当前正在进行中的活动
	 * 其他情况 都返回null
	 * @param appId
	 * @return
	 */
	@CheckForNull
	SeedRedPacketDto getCurrentActivity(Long appId);

	/**
	 * 查询app是否使用了组件化版本种红包
	 *
	 * @param appId
	 * @return
	 */
	Boolean isUseNewVersion(Long appId);


	/**
	 *
	 * @param appId
	 * @return
 	 * 查询appId当前正在进行中的h5活动
	 */
	public SeedRedPacketDto getCurrentActivityH5(Long appId);
}
