package cn.com.duiba.activity.center.api.dto.bet;

import cn.com.duiba.activity.center.api.enums.BetOpenAwardTypeEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/04/28
 */
public class BetConfigDto implements Serializable {
    private static final long serialVersionUID = 182095582760210989L;
    private Long id;
    private String title;
    private Long shareExp;
    private Date startTime;
    private Date endTime;
    private Long pluginId;
    private Long prizeLimit;
    /**
     * 投注活动的状态：1关闭不可见2关闭可见3开启4结束
     */
    private Integer configStatus;

    /**
     * 每人分得红包金额
     */
    private String bonusAmount;
    /**
     * 积分价值
     */
    private String creditsValue;
    private Integer betType;
    private Integer bonusType;
    private List<BetOptionDto> betOptionDtoList;

    private List<BetConfigRewardParam> prizeOptions;
    /**
     * AttributionTypeEnum
     */
    private Integer attributionType;

    private Long appId;

    /**
     * 正确答案id,默认不走答案流程
     */
    private Long rightAnswerOptionId;
    /**
     * 获奖人数总计
     * 1.attribution_type=2有效
     */
    private Integer winningBetTimes;

    /**
     * pk答题在第一个用户参与后多少小时开奖
     */
    private Integer delayHours = 0;

    /**
     * pk题目开奖类型。红包模式只允许延迟开奖   1 延迟开奖，2 定时开奖
     */
    private BetOpenAwardTypeEnum drawType;

    /**
     * 押注截止时间
     */
    private Date betEndTime;

    /**
     * OpenPrizeStatusEnum
     */
    private Integer openPrizeStatus;

    public Integer getOpenPrizeStatus() {
        return openPrizeStatus;
    }

    public void setOpenPrizeStatus(Integer openPrizeStatus) {
        this.openPrizeStatus = openPrizeStatus;
    }

    public Integer getWinningBetTimes() {
        return winningBetTimes;
    }

    public void setWinningBetTimes(Integer winningBetTimes) {
        this.winningBetTimes = winningBetTimes;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getRightAnswerOptionId() {
        return rightAnswerOptionId;
    }

    public void setRightAnswerOptionId(Long rightAnswerOptionId) {
        this.rightAnswerOptionId = rightAnswerOptionId;
    }

    public Long getPluginId() {
        return pluginId;
    }

    public void setPluginId(Long pluginId) {
        this.pluginId = pluginId;
    }

    public Long getPrizeLimit() {
        return prizeLimit;
    }

    public void setPrizeLimit(Long prizeLimit) {
        this.prizeLimit = prizeLimit;
    }

    public List<BetOptionDto> getBetOptionDtoList() {
        return betOptionDtoList;
    }

    public void setBetOptionDtoList(List<BetOptionDto> betOptionDtoList) {
        this.betOptionDtoList = betOptionDtoList;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getConfigStatus() {
        return configStatus;
    }

    public void setConfigStatus(Integer configStatus) {
        this.configStatus = configStatus;
    }

    public Long getShareExp() {
        return shareExp;
    }

    public void setShareExp(Long shareExp) {
        this.shareExp = shareExp;
    }

    public String getCreditsValue() {
        return creditsValue;
    }

    public void setCreditsValue(String creditsValue) {
        this.creditsValue = creditsValue;
    }

    public Integer getBetType() {
        return betType;
    }

    public void setBetType(Integer betType) {
        this.betType = betType;
    }

    public Integer getBonusType() {
        return bonusType;
    }

    public void setBonusType(Integer bonusType) {
        this.bonusType = bonusType;
    }

    public String getBonusAmount() {
        return bonusAmount;
    }

    public void setBonusAmount(String bonusAmount) {
        this.bonusAmount = bonusAmount;
    }

    public Integer getAttributionType() {
        return attributionType;
    }

    public void setAttributionType(Integer attributionType) {
        this.attributionType = attributionType;
    }

    public Integer getDelayHours() {
        return delayHours;
    }

    public void setDelayHours(Integer delayHours) {
        this.delayHours = delayHours;
    }

    public BetOpenAwardTypeEnum getDrawType() {
        return drawType;
    }

    public void setDrawType(BetOpenAwardTypeEnum drawType) {
        this.drawType = drawType;
    }

    public Date getBetEndTime() {
        return betEndTime;
    }

    public void setBetEndTime(Date betEndTime) {
        this.betEndTime = betEndTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public List<BetConfigRewardParam> getPrizeOptions() {
        return prizeOptions;
    }

    public void setPrizeOptions(List<BetConfigRewardParam> prizeOptions) {
        this.prizeOptions = prizeOptions;
    }
}
