package cn.com.duiba.activity.center.api.enums.managermarket;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @Author: lufeng
 * @Description: 客户经理营销中心 员工操作类型枚举
 * @Date: Created in 2020/8/6
 */
public enum StaffOpTypeEnum {

    WX_FRIEND(1, "转发微信好友"),
    WX_CIRCLE(2, "转发朋友圈"),
    URL_OPENED(3, "活动被打开"),
    URL_BINDED(4, "活动绑定"),
    ;

    StaffOpTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private Integer code;

    private String msg;

    private static Map<Integer, StaffOpTypeEnum> map = Maps.newHashMap();

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    static{
        for(StaffOpTypeEnum staffOpTypeEnum : StaffOpTypeEnum.values()){
            map.put(staffOpTypeEnum.getCode(),staffOpTypeEnum);
        }
    }

    public static StaffOpTypeEnum getByCode(Integer code){
        return map.get(code);
    }
}
