package cn.com.duiba.activity.center.api.remoteservice.understandlevel;

import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandLevelActionRecordDto;
import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandLevelAssistRecordDto;
import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandLevelConfigDto;
import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandOptionDto;
import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandPictureDto;
import cn.com.duiba.activity.center.api.dto.understandlevel.UnderstandPrizeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 默契测试活动接口
 *
 * @author haojiahong
 * @date 2021-03-11
 */
@AdvancedFeignClient
public interface RemoteUnderstandLevelService {

    /**
     * 保存默契测试活动配置
     *
     * @param understandLevelConfigDto
     * @return
     */
    Long saveOrUpdateAllConfig(UnderstandLevelConfigDto understandLevelConfigDto);


    /**
     * 查询默契测试活动配置
     *
     * @return
     */
    UnderstandLevelConfigDto getAllConfig(Long id);


    /**
     * 查询默契测试活动基本配置（基本信息+选项信息）
     *
     * @param id 活动配置id
     * @return
     */
    UnderstandLevelConfigDto getBaseConfig(Long id);


    /**
     * 判断用户是否已参与活动
     *
     * @param configId 活动配置id
     * @param cid      cid
     * @return
     */
    Boolean isUserJoin(Long configId, Long cid);


    /**
     * 判断用户是否已助力
     *
     * @param configId       活动配置id
     * @param cid            cid
     * @param actionRecordId 助力码
     * @return
     */
    Boolean isUserAssist(Long configId, Long cid, Long actionRecordId);

    /**
     * 判断用户是否已生成画像
     *
     * @param configId
     * @param cid
     * @return
     */
    Boolean isUserCreatePicture(Long configId, Long cid);


    /**
     * 查询要显示的奖品配置信息
     *
     * @param configId 活动配置id
     * @return
     */
    List<UnderstandPrizeDto> getPrizeConfig(Long configId);

    /**
     * 查询所有奖品信息（包含不显示）
     *
     * @param configId
     * @return
     */
    List<UnderstandPrizeDto> getAllPrizeConfig(Long configId);

    /**
     * 新增参与记录
     *
     * @param actionRecordDto
     * @return
     */
    Long insertActionRecord(UnderstandLevelActionRecordDto actionRecordDto);


    /**
     * 更新参与记录
     *
     * @param actionRecordDto
     * @return
     */
    Long updateActionRecordById(UnderstandLevelActionRecordDto actionRecordDto);


    /**
     * 根据id查询提交选项的参与记录
     *
     * @param id
     * @return
     */
    UnderstandLevelActionRecordDto getActionRecordById(Long id);

    /**
     * 查询参与记录
     *
     * @param configId
     * @param cid
     * @param orderNum
     * @return
     */
    UnderstandLevelActionRecordDto getActionRecord(Long configId, Long cid, String orderNum);


    /**
     * 查询已提交选项的参与记录
     *
     * @param configId
     * @param cid
     * @return
     */
    UnderstandLevelActionRecordDto getJoinedRecord(Long configId, Long cid);


    /**
     * 查询某个助力码关联的所有助力记录，并通过默契值由高到低排序
     * 最多返回500条记录
     *
     * @param configId
     * @param actionRecordId
     * @return
     */
    List<UnderstandLevelAssistRecordDto> getAssistRecordListByItemCode(Long configId, Long actionRecordId);


    /**
     * 根据选项id集合查询选项
     *
     * @param optionIdList
     * @return
     */
    List<UnderstandOptionDto> getOptionListByIds(List<Long> optionIdList);


    /**
     * 查询助力人给某个助力码的助力记录
     *
     * @param configId       活动配置id
     * @param cid            助力用户id
     * @param actionRecordId 助力码
     * @return
     */
    UnderstandLevelAssistRecordDto getAssistRecord4ItemCode(Long configId, Long cid, Long actionRecordId);


    /**
     * 通过id查询助力记录
     *
     * @param id
     * @return
     */
    UnderstandLevelAssistRecordDto getAssistRecordById(Long id);

    /**
     * 新增助力记录
     *
     * @param assistRecordDto
     * @return
     */
    Long insertAssistRecord(UnderstandLevelAssistRecordDto assistRecordDto);


    /**
     * 更新助力记录
     *
     * @param assistRecordDto
     * @return
     */
    Long updateAssistRecordById(UnderstandLevelAssistRecordDto assistRecordDto);


    /**
     * cas奖品剩余数量
     *
     * @param prizeId     奖品id
     * @param expectStock 期望剩余数量
     * @param newStock    要更新的剩余数量
     * @return
     */
    Boolean casPrizeRemind(Long prizeId, Integer expectStock, Integer newStock);


    /**
     * 扣减奖品剩余数量
     *
     * @param prizeId
     * @return
     */
    Boolean decrPrizeStock(Long prizeId);

    /**
     * 回滚奖品剩余数量
     *
     * @param prizeId
     * @return
     */
    Boolean rollbackPrizeStock(Long prizeId);


    /**
     * 查询画像列表
     *
     * @param configId         活动配置id
     * @param pictureIndexList 画像序号集合
     * @return
     */
    List<UnderstandPictureDto> getRelaPictureList(Long configId, List<Integer> pictureIndexList);

    /**
     * 根据id查询画像
     *
     * @param id
     * @return
     */
    UnderstandPictureDto getPictureById(Long id);
}
