package cn.com.duiba.activity.center.api.enums;

/**
 * @author: zhengjianhao
 * @date: 18/7/26 16:08
 * @description: 猜红包-红包状态
 */
public enum GuessRedPacketStatusEnum {

    CAN_GUESS(1, "未被猜中，仍可被猜"),
    HAS_BE_GUESSED(2, "已被猜中"),
    GUESS_TIME_FULL(3, "被猜次数已满"),

    UN_RECEIVE(4, "未领取"),
    RECEIVED_SUCCESS(5, "领取成功"),
    RECEIVED_FAIL(6, "领取失败"),
    ;

    /**
     * 系统空间定义
     */
    private Integer status;
    private String desc;

    GuessRedPacketStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
