package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.enums.label.StrategyEffectiveTargerEnum;

import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Created by zhangyongjie on 2021/7/26 4:21 下午
 */
public enum UserLabelStrategyRelTypeEnum {
    TASK(1,"任务"),
    GOODS_PACK(2,"商品组件");

    private int code;
    private String message;

    UserLabelStrategyRelTypeEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }


    public static UserLabelStrategyRelTypeEnum getByTargetType(Integer targetType){
        UserLabelStrategyRelTypeEnum[] values = UserLabelStrategyRelTypeEnum.values();
        for(UserLabelStrategyRelTypeEnum result : values){
            if(result.code == targetType / 2){
                return result;
            }
        }
        return TASK;
    }
}