package cn.com.duiba.activity.center.api.enums.bet;


public enum BetExchangeStatusEnum {
    EXCHANGE_STATUS_INIT(-1, "初始化"),
    EXCHANGE_STATUS_NO(0, "无需领奖"),
    EXCHANGE_STATUS_WATTING(1, "待领奖"),
    EXCHANGE_STATUS_SUCCESS(2, "领奖成功"),
    EXCHANGE_STATUS_FAIL(3, "领奖失败"),
    EXCHANGE_STATUS_EXPIRE(4, "过期未领奖失效"),
    EXCHANGE_STATUS_DEALING(5, "领奖中"),
    EXCHANGE_BONUS_RUN_OUT(6, "已领完"),
    ;


    private Integer code;
    private String desc;

    BetExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BetExchangeStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (BetExchangeStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
