package cn.com.duiba.activity.center.api.remoteservice.cctv;

import cn.com.duiba.activity.center.api.dto.cctv.AllTaskUnitDto;
import cn.com.duiba.activity.center.api.dto.cctv.TaskUnitDto;
import cn.com.duiba.activity.center.api.params.cctv.AllTaskQueryParam;
import cn.com.duiba.activity.center.api.params.cctv.TaskQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 央视影音 任务组件
 *
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteTaskUnitService {
    /**
     * 根据任务周期 查询任务记录
     *
     * @param param 查询条件
     * @return 记录
     */
    List<TaskUnitDto> queryByTypes(TaskQueryParam param);

    /**
     * @param param
     * @return
     */
    List<TaskUnitDto> queryByType(TaskQueryParam param);

    /**
     * 批量删除任务记录
     *
     * @param taskIds
     * @return
     */
    int batchDelete(List<Long> taskIds);

    /**
     * 保存
     *
     * @param dto -
     * @return 是否保存成功
     */
    Boolean save(TaskUnitDto dto);

    /**
     * 【央视影音】 查询所有类型的任务
     *
     * @param param 查询条件
     * @return
     */
    AllTaskUnitDto findAllTaskRecord(AllTaskQueryParam param);

    /**
     * 设置extra字段数据
     * 
     * @param taskUnitDto
     * @return
     */
    int setExtraInfo(TaskUnitDto taskUnitDto);

    /**
     * 保存
     *
     * @param dto -
     * @return 是否保存成功
     */
    Long saveV2(TaskUnitDto dto);
}
