package cn.com.duiba.activity.center.api.remoteservice.label.param;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
public class LabelPassGoodsFilterParamBuilder {

    private List<Long> appItemIds;

    private String strategyType;

    private Long appId;

    private Long cid;

    private String userId;

    private List<String> strategyContents;

    public LabelPassGoodsFilterParamBuilder setStrategyContents(List<String> strategyContents) {
        this.strategyContents = strategyContents;
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setAppItemIds(List<Long> appItemIds) {
        this.appItemIds = appItemIds;
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setAppItemIds(Long... appItemIds) {
        if (appItemIds == null || appItemIds.length == 0) {
            return this;
        }
        if (this.appItemIds == null) {
            this.appItemIds = new ArrayList<>();
        }
        for (Long appItemId : appItemIds) {
            if (appItemId != null) {
                this.appItemIds.add(appItemId);
            }
        }
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setStrategyType(String strategyType) {
        this.strategyType = strategyType;
        return this;
    }

    public LabelPassGoodsFilterParamBuilder setAppId(Long appId) {
        this.appId = appId;
        return this;

    }

    public LabelPassGoodsFilterParamBuilder setCid(Long cid) {
        this.cid = cid;
        return this;

    }

    public LabelPassGoodsFilterParamBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public LabelPassGoodsFilterParam builder(){
        if (StringUtils.isBlank(strategyType)){
            throw new IllegalArgumentException("strategyType not blank");
        }
        if(appId == null){
            throw new IllegalArgumentException("appId not null");
        }
        if (CollectionUtils.isEmpty(appItemIds)&&CollectionUtils.isEmpty(strategyContents)){
            throw new IllegalArgumentException("appItemIds or strategyContents not empty");
        }
        if (StringUtils.isBlank(userId)){
            throw new IllegalArgumentException("userId not blank");
        }
        LabelPassGoodsFilterParam param = new LabelPassGoodsFilterParam();
        param.setAppItemIds(appItemIds);
        param.setAppId(appId);
        param.setStrategyType(strategyType);
        param.setUserId(userId);
        param.setCid(cid);
        param.setStrategyContents(strategyContents);
        return param;
    }

    public LabelPassGoodsFilterParamBuilder setStrategyContents(String... strategyContents) {
        if (StringUtils.isAnyBlank(strategyContents)) {
            return this;
        }
        if (this.strategyContents == null) {
            this.strategyContents = new ArrayList<>();
        }
        for (String strategyContent : strategyContents) {
            if (StringUtils.isNotBlank(strategyContent)) {
                this.strategyContents.add(strategyContent);
            }
        }
        return this;
    }
}
