package cn.com.duiba.activity.center.api.dto.question;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;

/**
 * 
 * ClassName: QuestionOptionsDto <br/>
 * date: 2016年12月1日 上午10:25:31 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
public class QuestionOptionsDto implements Serializable {

	private static final long serialVersionUID = -4739233238321491831L;
	
	private Long id;
	private String title;
	private String image;
	private Integer payload;

	private Long duibaQuestionAnswerId;
	private Long itemId;
	private String description;
	private String logo;
	private String name;
	private String prizeType;
	private Long facePrice;
	private Integer remaining;
	private Integer hidden;
	private Integer qualifyNum;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 
	 * Creates a new instance of QuestionOptionsDto.
	 *
	 */
	public QuestionOptionsDto() {
	}

	/**
	 * 
	 * Creates a new instance of QuestionOptionsDto.
	 *
	 * @param duibaQuestionAnswerOptionsDO
	 */
	public QuestionOptionsDto(DuibaQuestionAnswerOptionsDto duibaQuestionAnswerOptionsDO) {
		this.id = duibaQuestionAnswerOptionsDO.getId();
		this.title = duibaQuestionAnswerOptionsDO.getName();
		this.image = duibaQuestionAnswerOptionsDO.getLogo();
		this.payload = duibaQuestionAnswerOptionsDO.getPayload();
		this.duibaQuestionAnswerId = duibaQuestionAnswerOptionsDO.getDuibaQuestionAnswerId();
		this.itemId = duibaQuestionAnswerOptionsDO.getItemId();
		this.description = duibaQuestionAnswerOptionsDO.getDescription();
		this.logo = duibaQuestionAnswerOptionsDO.getLogo();
		this.name = duibaQuestionAnswerOptionsDO.getName();
		this.prizeType = duibaQuestionAnswerOptionsDO.getPrizeType();
		this.facePrice = duibaQuestionAnswerOptionsDO.getFacePrice();
		this.remaining = duibaQuestionAnswerOptionsDO.getRemaining();
		this.hidden = duibaQuestionAnswerOptionsDO.getHidden();
		this.qualifyNum = duibaQuestionAnswerOptionsDO.getQualifyNum();
		this.deleted = duibaQuestionAnswerOptionsDO.getDeleted();
		this.gmtCreate = duibaQuestionAnswerOptionsDO.getGmtCreate();
		this.gmtModified = duibaQuestionAnswerOptionsDO.getGmtModified();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public Long getDuibaQuestionAnswerId() {
		return duibaQuestionAnswerId;
	}

	public void setDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
		this.duibaQuestionAnswerId = duibaQuestionAnswerId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public Long getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(Long facePrice) {
		this.facePrice = facePrice;
	}

	public Integer getRemaining() {
		return remaining;
	}

	public void setRemaining(Integer remaining) {
		this.remaining = remaining;
	}

	public Integer getHidden() {
		return hidden;
	}

	public void setHidden(Integer hidden) {
		this.hidden = hidden;
	}

	public Integer getQualifyNum() {
		return qualifyNum;
	}

	public void setQualifyNum(Integer qualifyNum) {
		this.qualifyNum = qualifyNum;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

}
