package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.service.exception.BusinessException;

/**
 * 活动工具消费库存消费
 * @author zp
 * from HdtoolConsumeStockService
 *
 */
@AdvancedFeignClient
public interface RemoteHdtoolStockConsumeService {

	/**
	 * 兑吧活动工具扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	@Deprecated
	public void consumeDuibaHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException;

	public void consumeDuibaHdtoolOptionStockApi(Long optionId, Long appId, String bizId, String bizSource) throws BizException;
	
	/**
	 * 兑吧活动工具返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	@Deprecated
	public void paybackDuibaHdtoolOptionStock(String bizId, String bizSource) throws BusinessException;

	public void paybackDuibaHdtoolOptionStockApi(String bizId, String bizSource) throws BizException;
	
	/**
	 * 开发者活动工具扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	@Deprecated
	public void consumeAppHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException;

	public void consumeAppHdtoolOptionStockApi(Long optionId, Long appId, String bizId, String bizSource) throws BizException;
	
	/**
	 * 开发者活动工具返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	@Deprecated
	public void paybackAppHdtoolOptionStock(String bizId, String bizSource) throws BusinessException;

	public void paybackAppHdtoolOptionStockApi(String bizId, String bizSource) throws BizException;
}
