package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcHdtoolFreeTimesDto;
import cn.com.duiba.activity.center.api.params.hsbc.HsbcFreeTimeQueryParams;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteHsbcHdtoolFreeTimeService {

    /**
     * 根据cid、周期类型查询记录
     *
     * @param params 查询条件
     * @return 免费次数记录
     */
    List<HsbcHdtoolFreeTimesDto> findTaskByCidAndScopeTypes(HsbcFreeTimeQueryParams params);

    /**
     * 根据cid、周期开始、结束时间查询记录
     *
     * @param params 查询条件
     * @return 免费次数记录
     */
    List<HsbcHdtoolFreeTimesDto> findAllByCidAndScopeTimes(HsbcFreeTimeQueryParams params);



    /**
     * 批量更新
     *
     * @param freeTimeList 数据列表
     * @return 影响行数
     */
    int batchUpdateFreeTimes(List<HsbcHdtoolFreeTimesDto> freeTimeList);

    /**
     * 批量插入
     *
     * @param freeTimeList 数据列表
     * @return 影响行数
     */
    int batchInsert(List<HsbcHdtoolFreeTimesDto> freeTimeList);


    /**
     * 查询某活动工具周期免费次数
     *
     * @param params          查询条件
     * @return 免费次数
     */
    List<HsbcHdtoolFreeTimesDto> findUserActivityScopeFreeTimes(HsbcFreeTimeQueryParams params);


    /**
     * 查询某活动工具永久免费次数
     *
     * @param params 查询条件
     * @return 免费次数
     */
    List<HsbcHdtoolFreeTimesDto> findUserActivityForeverFreeTimes(HsbcFreeTimeQueryParams params);


    /**
     * 查询用户某taskId的永久次数
     *
     * @param params 查询条件
     * @return 免费次数
     */
    List<HsbcHdtoolFreeTimesDto> findUserForeverTimesByTaskId(HsbcFreeTimeQueryParams params);


    /**
     * 累加消耗机会
     *
     * @param id 主键
     * @return 是否修改成功
     */
    boolean increaseConsumeTimes(Long id);
}
