package cn.com.duiba.activity.center.api.enums;


/**
 * 兑吧书籍类型
 * @author zhengwei
 */
public enum DuibaBookTypeEnum {

    EXCELLENT_WORK(1, "出版佳作"),
    EXCELLENT_COURSE(2, "精品课程"),
    BOYS_LISTEN(3, "男生必听"),
    GIRLS_LISTEN(4, "女生必听");

    private Integer value;

    private String desc;

    DuibaBookTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean contains(Integer value) {
        for (DuibaBookTypeEnum bookType : DuibaBookTypeEnum.values()) {
            if (bookType.value.equals(value)) {
                return true;
            }
        }
        return false;
    }

    public static String descOf(Integer value){
        for (DuibaBookTypeEnum bookTypeEnum : DuibaBookTypeEnum.values()) {
            if (bookTypeEnum.value.equals(value)) {
                return bookTypeEnum.desc;
            }
        }
        return null;
    }

}
