package cn.com.duiba.activity.center.api.remoteservice.tlcb;

import cn.com.duiba.activity.center.api.dto.tlcb.ConsumerTaskInfoDto;
import cn.com.duiba.activity.center.api.dto.tlcb.ConsumerTaskUnitInfoDto;
import cn.com.duiba.activity.center.api.dto.tlcb.TaskRecordDto;
import cn.com.duiba.activity.center.api.dto.tlcb.TaskUnitConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;


/**
 * @author: pengyi
 * @description:
 * @date: 2022/6/13 上午10:29
 */
@AdvancedFeignClient
public interface RemoteTaiLongTaskUnitService {

    /**
     * 查找任务组件配置信息
     * @param appId
     * @param actId
     * @return
     * @throws Exception
     */
    TaskUnitConfigDto findTaskUnitConfig(Long appId, Long actId) throws Exception;

    /**
     * 保存/编辑任务组件配置
     * @param dto
     * @return
     * @throws Exception
     */
    Long saveOrUpdateTaskUnitConfig(TaskUnitConfigDto dto) throws Exception;

    /**
     * 生成/修改任务记录
     * @param taskRecordDto
     * @return
     */
    Boolean saveOrUpdateTaskRecord(TaskRecordDto taskRecordDto);

    /**
     * C端任务组件信息
     * @param actId
     * @param consumerId
     * @return
     */
    ConsumerTaskUnitInfoDto getTaskUnitIndex(Long actId, Long consumerId);

    /**
     * C端用户任务
     * @param taskId
     * @param consumerId
     * @return
     */
    ConsumerTaskInfoDto getConsumerTask(Long taskId, Long consumerId);

    /**
     * 查询用户任务记录
     * @param taskId
     * @param consumerId
     * @return
     */
    TaskRecordDto findConsumerTaskRecord(Long taskId, Long consumerId);

    /**
     * 扣奖品库存
     * @param taskId
     * @return
     */
    Boolean consumePrizeStock(Long taskId);

    /**
     * 回滚奖品库存
     * @param taskId
     * @return
     */
    Boolean rollbackPrizeStock(Long taskId);

    /**
     * 修改任务记录状态
     * @param orderNum
     * @param activityOrderNum
     * @param status
     * @return
     */
    Boolean updateRecordByOrderNum(String orderNum, String activityOrderNum, Integer status);

    /**
     * 查找任务记录
     * @param recordIds
     * @return
     */
    List<TaskRecordDto> findRecordListByIds(List<Long> recordIds);

    /**
     * 查询任务记录
     * @param recordId
     * @return
             */
    TaskRecordDto findRecordById(Long recordId);


}
