package cn.com.duiba.activity.center.api.aop;

import cn.com.duiba.activity.center.api.anno.ActivityUserWhitelistAnno;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * Created by hong
 * time 2022/9/7.
 */
@Aspect
@Component
public class ActivityUserWhitelistAop {
    @Pointcut("@annotation(cn.com.duiba.activity.center.api.anno.ActivityUserWhitelistAnno)")
    public void activityUserWhitelistAopPoint() {

    }

    @Around("activityUserWhitelistAopPoint()")
    public String reqAround(ProceedingJoinPoint joinPoint) {
        String           rtValue = null;
        Method                    method = ((MethodSignature) joinPoint.getSignature()).getMethod();
        ActivityUserWhitelistAnno anno   = method.getDeclaredAnnotation(ActivityUserWhitelistAnno.class);
        if (anno != null) {
            Object reqContent = null;
            Object opt = null;
            Object[]       args                 = joinPoint.getArgs();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            if (args != null && args.length != 0) {
                int i = 0;
                for (Annotation[] paramAnnoArr : parameterAnnotations) {
                    for (Annotation paramAnno : paramAnnoArr) {
                        if (paramAnno instanceof RequestBody) {
                            reqContent = args[i];
                        }
                    }
                    i++;
                }
            }
            AnnotationResolver annotationResolver = AnnotationResolver.newInstance();
            Object paramObj = annotationResolver.resolver(joinPoint, anno.activityId());
            return (String) paramObj;
        }
        return null;
    }
}
