package cn.com.duiba.activity.center.api.remoteservice.app_survey;

import cn.com.duiba.activity.center.api.dto.app_survey.AppSurveyConfigDto;
import cn.com.duiba.activity.center.api.dto.app_survey.AppSurveySubmitRecordDto;
import cn.com.duiba.activity.center.api.dto.app_survey.AppSurveyUserAnswerDto;
import cn.com.duiba.activity.center.api.params.app_survey.SubmitRecordPageParam;
import cn.com.duiba.activity.center.api.params.app_survey.UserSubmitSurveyParams;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 开发者问卷活动工具 remote api
 *
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteAppSurveyService {

    /**
     * 保存问卷配置
     *
     * @param configDto 问卷配置
     * @param isPublish true: 发布
     * @throws BizException S.H.I.T happens
     */
    void saveSurveyConfig(AppSurveyConfigDto configDto, boolean isPublish) throws BizException;

    /**
     * 编辑问卷配置
     *
     * @param configDto 问卷配置
     * @param isPublish true: 发布
     * @throws BizException S.H.I.T happens
     */
    void editSurveyConfig(AppSurveyConfigDto configDto, boolean isPublish) throws BizException;

    /**
     * 查询问卷配置
     *
     * @param operatingActivityId 入库活动id
     * @return 配置
     * @throws BizException S.H.I.T happens
     */
    AppSurveyConfigDto findSurveyConfigByOpId(Long operatingActivityId) throws BizException;


    /**
     * 查询问卷配置
     *
     * @param surveyId 活动id
     * @return 配置
     * @throws BizException S.H.I.T happens
     */
    AppSurveyConfigDto findSurveyConfigById(Long surveyId) throws BizException;


    /**
     * 问卷基础配置（不返回题目、选项）
     *
     * @param surveyId 活动id
     * @return 问卷基础配置
     * @throws BizException S.H.I.T happens
     */
    AppSurveyConfigDto findBaseConfigById(Long surveyId) throws BizException;


    /**
     * 问卷基础配置（不返回题目、选项）
     *
     * @param operatingActivityId 入库活动id
     * @return 问卷基础配置
     * @throws BizException S.H.I.T happens
     */
    AppSurveyConfigDto findBaseConfigByOpId(Long operatingActivityId) throws BizException;


    /**
     * 根据用户id、问卷id 查找用户的提交记录
     *
     * @param consumerId 用户id
     * @param surveyId   活动id
     * @return 提交记录
     * @throws BizException S.H.I.T happens
     */
    AppSurveySubmitRecordDto findRecordBySurveyIdAndCid(Long consumerId, Long surveyId) throws BizException;


    /**
     * 用户提交答案
     *
     * @param userSubmitSurveyParams 用户提交答案
     */
    void saveUserSubmitAnswer(UserSubmitSurveyParams userSubmitSurveyParams);


    /**
     * 分页查询用户提交记录
     *
     * @param pageParam 分页请求参数
     * @return 分页查询结果
     */
    Page<AppSurveySubmitRecordDto> userSubmitRecordPageQuery(SubmitRecordPageParam pageParam);


    /**
     * 根据id查询提交记录
     *
     * @param id 主键
     * @return 提交记录
     */
    AppSurveySubmitRecordDto findSubmitRecordById(Long id);


    /**
     * 查询用户提交的答案
     *
     * @param recordId 提交记录id
     * @return 用户提交答案
     */
    List<AppSurveyUserAnswerDto> findUserAnswerByRecordId(Long recordId);

    /**
     * 批量查询用户提交的答案
     *
     * @param recordIdList
     * @return
     */
    List<AppSurveyUserAnswerDto> batchFindUserAnswerByRecordId(List<Long> recordIdList);
}
