/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.aop;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class AnnotationResolver {
    private static AnnotationResolver resolver;

    public static AnnotationResolver newInstance() {
        if (resolver == null) {
            resolver = new AnnotationResolver();
            return resolver;
        }
        return resolver;
    }

    public Object resolver(JoinPoint joinPoint, String str) {
        if (str == null) {
            return null;
        }
        Object value = null;
        if (str.matches("#\\D*")) {
            String newStr = str.replaceAll("#", "").replaceAll("", "");
            if (newStr.contains(".")) {
                try {
                    value = this.complexResolver(joinPoint, newStr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                value = this.simpleResolver(joinPoint, newStr);
            }
        } else {
            value = str;
        }
        return value;
    }

    private Object complexResolver(JoinPoint joinPoint, String str) throws Exception {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] names = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        String[] strs = str.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            if (!strs[0].equals(names[i])) continue;
            Object obj = args[i];
            Method dmethod = obj.getClass().getDeclaredMethod(this.getMethodName(strs[1]), null);
            Object value = dmethod.invoke(args[i], new Object[0]);
            return this.getValue(value, 1, strs);
        }
        return null;
    }

    private Object getValue(Object obj, int index, String[] strs) {
        try {
            if (obj != null && index < strs.length - 1) {
                Method method = obj.getClass().getDeclaredMethod(this.getMethodName(strs[index + 1]), null);
                obj = method.invoke(obj, new Object[0]);
                this.getValue(obj, index + 1, strs);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getMethodName(String name) {
        return "get" + name.replaceFirst(name.substring(0, 1), name.substring(0, 1).toUpperCase());
    }

    private Object simpleResolver(JoinPoint joinPoint, String str) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] names = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < names.length; ++i) {
            if (!str.equals(names[i])) continue;
            return args[i];
        }
        return null;
    }
}

