package cn.com.duiba.activity.center.api.dto.app_survey;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 开发者问券活动配置
 *
 * @author fja
 * @since 2022-07-21 18:03:59
 */
public class AppSurveyConfigDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 问卷id
     */
    private Long id;

    /**
     * 活动入库id
     */
    private Long opId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 问卷标题（活动标题）
     */
    private String surveyTitle;

    /**
     * 问卷规则（活动规则）
     */
    private String surveyRule;

    /**
     * 活动开始时间
     */
    private Date startTime;


    /**
     * 活动结束时间
     */
    private Date endTime;


    /**
     * 缩略图
     */
    private String smallImage;


    /**
     * banner图
     */
    private String bannerImage;


    /**
     * 界面配置
     */
    private String interfaceConfig;


    /**
     * 0-关闭运营位，1-开启运营位
     */
    private Integer operationSwitch;


    /**
     * 运营配置，一个元素为一组运营位
     */
    private List<AppSurveyOperationConfigDto> operationConfigList;



    /**
     * 问卷题目列表
     */
    private List<AppSurveyQuestionDto> questionConfigList;


    /**
     * 定制字段
     */
    private String extraJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOpId() {
        return opId;
    }

    public void setOpId(Long opId) {
        this.opId = opId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSurveyTitle() {
        return surveyTitle;
    }

    public void setSurveyTitle(String surveyTitle) {
        this.surveyTitle = surveyTitle;
    }

    public String getSurveyRule() {
        return surveyRule;
    }

    public void setSurveyRule(String surveyRule) {
        this.surveyRule = surveyRule;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getInterfaceConfig() {
        return interfaceConfig;
    }

    public void setInterfaceConfig(String interfaceConfig) {
        this.interfaceConfig = interfaceConfig;
    }

    public Integer getOperationSwitch() {
        return operationSwitch;
    }

    public void setOperationSwitch(Integer operationSwitch) {
        this.operationSwitch = operationSwitch;
    }

    public List<AppSurveyOperationConfigDto> getOperationConfigList() {
        return operationConfigList;
    }

    public void setOperationConfigList(List<AppSurveyOperationConfigDto> operationConfigList) {
        this.operationConfigList = operationConfigList;
    }

    public List<AppSurveyQuestionDto> getQuestionConfigList() {
        return questionConfigList;
    }

    public void setQuestionConfigList(List<AppSurveyQuestionDto> questionConfigList) {
        this.questionConfigList = questionConfigList;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

