package cn.com.duiba.activity.center.api.enums;

import cn.com.duiba.activity.center.api.exception.ActivityCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: fss
 * @Date: 2021/9/17 14
 * @Description:
 */
public enum StationSyncTypeEnum {
    FIRST(1, "第一次同步"),
    SECOND(2, "发布后同步");

    private static Map<Integer, StationSyncTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (StationSyncTypeEnum typeEnum : StationSyncTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getType(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static StationSyncTypeEnum getByType(int code) {
        StationSyncTypeEnum type = typeEnumMap.get(code);
        if (type == null) {
            throw new ActivityCenterException("不支持的同步状态");
        }
        return type;
    }

    private Integer type;
    private String desc;

    StationSyncTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
