package cn.com.duiba.activity.center.api.remoteservice.alipayActivityRedpack;

import cn.com.duiba.activity.center.api.dto.alipay.AlipayActivityConfigDto;
import cn.com.duiba.activity.center.api.enums.alipay.RedpackActivityStatus;
import cn.com.duiba.activity.center.api.params.alipay.AlipayActivityConfigPageParam;
import cn.com.duiba.activity.center.api.params.alipay.AlipayActivityConfigParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName RemoteActivityConfig.java
 * @Description 支付宝链接券活动
 * @createTime 2022年11月17日 15:56:00
 */

@AdvancedFeignClient
public interface RemoteAlipayActivityConfig {

    /**
     * 分页查询红包活动
     * @param alipayActivityConfigPageParam
     * @return
     */
    Page<AlipayActivityConfigDto> pageByParams(AlipayActivityConfigPageParam alipayActivityConfigPageParam);

    /**
     * 根据活动id修改活动状态,同时其活动下的链接卷转态也会改变
     * @param activityId-活动id redpackActivityStatus-更改类型('0.正常  1.手动失效  2.自动结束')
     * @return
     */
    int updateActivityStatus(String activityId, RedpackActivityStatus redpackActivityStatus);

    /**
     * 新建活动
     * @param alipayActivityConfigParam
     * @return
     */
    int createActivity(AlipayActivityConfigParam alipayActivityConfigParam);

    /**
     * 判断该主体下的活动是否已经存在
     * @param pair left-活动主体 right-活动id
     * @return  true-已存在，false-不存在
     */
    Boolean activityExist(String activitySubject,String activityId);

    /**
     * 获取全部活动信息列表
     * @return
     */
    List<AlipayActivityConfigDto> activityList();




}
