package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益网点核销，渠道枚举类
 **/
public enum EquityVerifyChannelEnum {

    EXCHANGE(1, "普兑"),
    ACTIVITY(2, "活动"),
    ;
    private Integer code;
    private String desc;

    EquityVerifyChannelEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityVerifyChannelEnum ofValue(Integer code) {
        for (EquityVerifyChannelEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

