package cn.com.duiba.activity.center.api.remoteservice.alipayactivityredpack;

import cn.com.duiba.activity.center.api.dto.alipayactivityredpack.AlipayRepackCardDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName RemoteRepackCard.java
 * @Description 支付宝链接券-卡券
 * @createTime 2022年11月17日 18:11:00
 */
@AdvancedFeignClient
public interface RemoteRepackCard {

    /**
     * 存储链接卷
     * @return
     */
    void repackCardSave(List<AlipayRepackCardDto> alipayRepackCardDtos);


    /**
     * 根据短链查询链接卷详情
     * @param shortUrls 短链
     * @return 链接卷信息
     */
    List<AlipayRepackCardDto> findRepackCardInfoByUrl(List<String> shortUrls);

    /**
     * 获取该活动下的链接卷的状态映射
     * @return map key-url value-state
     */
    Map<String, Integer> getUrlAndState(String redpackActivityId);

    /**
     * 获取该活动下的链接卷信息
     * @param redpackActivityId
     * @return
     */
    List<AlipayRepackCardDto> getRepackCardInfoByActivityId(String redpackActivityId);


    /**
     * 根据短链修改链接卷信息
     * @param alipayRepackCardDto
     * @return
     */
    int updateByUrl( AlipayRepackCardDto alipayRepackCardDto);

    /**
     * 根据卡卷id修改链接卷信息
     * @param alipayRepackCardDto
     * @return
     */
    int updateByCouponId(AlipayRepackCardDto alipayRepackCardDto);

    /**
     * 统计该活动下已使用和已领取单卡卷数量
     * @param redpackActivityId
     * @return
     */
    int repackCardUsedCount(String redpackActivityId);




}
